/*
 * File:     ShortcutsCommand.java
 * Project:  MPI Linguistic Application
 * Date:     12 December 2007
 *
 * Copyright (C) 2001-2008  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

package mpi.eudico.client.annotator.commands;

import javax.swing.JFrame;


/**
 *
 */
public class ShortcutsCommand implements Command {
    private String commandName;
    private JFrame shortcutsFrame;

    /**
     * Creates a new ShortcutsCommand instance
     *
     * @param name DOCUMENT ME!
     */
    public ShortcutsCommand(String name) {
        commandName = name;
    }

    /**
     *
     */
    public void execute(Object receiver, Object[] arguments) {
        shortcutsFrame = (JFrame) (arguments[0]);

        showShortcuts();
    }

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public String getName() {
        return commandName;
    }

    private void showShortcuts() {
        if (shortcutsFrame != null) {
            //Next line useable as of JDK 1.4
            //shortcutsFrame.setExtendedState(Frame.NORMAL);
            shortcutsFrame.setVisible(true);
            shortcutsFrame.toFront();
        }
    }
}
