/*
 * File:     StructuredSearchMultipleDlgCommand.java
 * Project:  MPI Linguistic Application
 * Date:     12 December 2007
 *
 * Copyright (C) 2001-2008  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

package mpi.eudico.client.annotator.commands;

import mpi.eudico.client.annotator.ElanFrame2;
import mpi.eudico.client.annotator.ViewerManager2;

import mpi.eudico.client.annotator.smfsearch.StructuredMultipleFileSearchFrame;


/**
 * A Command that creates a frame for structured search in multiple files.
 *
 * @author Han Sloetjes
 */
public class StructuredSearchMultipleDlgCommand implements Command {
    private String commandName;

    /**
     * Creates a new structured search dialog command.
     *
     * @param name the name of the command
     */
    public StructuredSearchMultipleDlgCommand(String name) {
        commandName = name;
    }

    /**
     * <b>Note: </b>it is assumed the types and order of the arguments are
     * correct.
     *
     * @param receiver null, there is no clear receiver object for this command
     * @param arguments the arguments:  <ul><li>arg[0] = the ViewerManager for
     *        the document/frame from which the search frame is created
     *        (ViewerManager)</li> </ul>
     */
    public void execute(Object receiver, Object[] arguments) {
        ViewerManager2 vm = (ViewerManager2) arguments[0];

        new StructuredMultipleFileSearchFrame((ElanFrame2) ELANCommandFactory.getRootFrame(
                vm.getTranscription()));
    }

    /**
     * Returns the name of the command
     *
     * @return the name
     */
    public String getName() {
        return commandName;
    }
}
