/*
 * File:     ImportDelimitedTextMA.java
 * Project:  MPI Linguistic Application
 * Date:     12 December 2007
 *
 * Copyright (C) 2001-2008  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

package mpi.eudico.client.annotator.commands.global;

import mpi.eudico.client.annotator.ElanFrame2;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.FrameManager;
import mpi.eudico.client.annotator.Preferences;

import mpi.eudico.client.annotator.gui.ImportCSVDialog;

import mpi.eudico.client.annotator.util.ElanFileFilter;

import mpi.eudico.server.corpora.clom.Transcription;

import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;
import mpi.eudico.server.corpora.clomimpl.delimitedtext.DelimitedTextDecoderInfo;

import java.awt.event.ActionEvent;

import java.io.File;

import javax.swing.JFileChooser;
import javax.swing.JOptionPane;


/**
 * Shows a file chooser and next creates an import options window for tab
 * delimited or csv file.
 *
 * @author Han Sloetjes
 */
public class ImportDelimitedTextMA extends FrameMenuAction {
    /**
     * Creates a new ImportDelimitedTextMA instance
     *
     * @param name the name of the menu
     * @param frame the ELAN frame
     */
    public ImportDelimitedTextMA(String name, ElanFrame2 frame) {
        super(name, frame);
    }

    /**
     * Creates a chooser to select a .csv or .txt file and next creates an
     * import  delimited text dialog.
     *
     * @param e action event
     */
    public void actionPerformed(ActionEvent e) {
        JFileChooser chooser = new JFileChooser();

        chooser.setFileFilter(ElanFileFilter.createFileFilter(
                ElanFileFilter.CSV_TYPE));
        chooser.setDialogTitle(ElanLocale.getString(
                "Frame.ElanFrame.OpenDialog.Title"));

        String dirPath = (String) Preferences.get("LastUsedCSVDir", null);

        if (dirPath == null) {
            // user.dir is probably a better choice than home.dir?
            dirPath = System.getProperty("user.dir");
        }

        chooser.setCurrentDirectory(new File(dirPath));

        int returnVal = chooser.showOpenDialog(frame);
        File csvFile = null;
        String fullPath = null;

        if (returnVal == JFileChooser.APPROVE_OPTION) {
            fullPath = chooser.getSelectedFile().getAbsolutePath();

            File fileTemp = new File(fullPath);

            //check if file exists and is a file
            if (!fileTemp.exists() || fileTemp.isDirectory()) {
                String strMessage = ElanLocale.getString("Menu.Dialog.Message1");
                strMessage += fullPath;
                strMessage += ElanLocale.getString("Menu.Dialog.Message2");

                String strError = ElanLocale.getString("Message.Error");
                JOptionPane.showMessageDialog(frame, strMessage, strError,
                    JOptionPane.ERROR_MESSAGE);

                return;
            }

            csvFile = fileTemp;

            // don't check if file is a '.csv' or '.txt' file

            /*
               if (fileTemp.toString().toLowerCase().endsWith(".csv") == false &&
                       fileTemp.toString().toLowerCase().endsWith(".txt") == false) {
                   String strMessage = ElanLocale.getString("Menu.Dialog.Message1");
                   strMessage += fullPath;
                   strMessage += ElanLocale.getString("Menu.Dialog.Message3");
                   String strError = ElanLocale.getString("Message.Error");
                   JOptionPane.showMessageDialog(frame, strMessage, strError,
                       JOptionPane.ERROR_MESSAGE);
                   return;
               }
             */
            ImportCSVDialog dialog = new ImportCSVDialog(frame, fileTemp);
            Object value = dialog.showDialog();

            if ((value == null) ||
                    !(value instanceof DelimitedTextDecoderInfo)) {
                return;
            }

            DelimitedTextDecoderInfo decInfo = (DelimitedTextDecoderInfo) value;

            try {
                String path = fullPath;
                Preferences.set("LastUsedCSVDir", (new File(path)).getParent(),
                    null);

                // replace all backslashes by forward slashes
                path = path.replace('\\', '/');

                //long before = System.currentTimeMillis();
                //Transcription transcription = new TranscriptionImpl(new File(path).getAbsolutePath());
                path = decInfo.getSourceFilePath();

                Transcription transcription = new TranscriptionImpl(path,
                        decInfo);

                //long after = System.currentTimeMillis();
                //System.out.println("open eaf took " + (after - before) + "ms");
                transcription.setChanged();

                FrameManager.getInstance().createFrame(transcription);
            } catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }
}
