/*
 * File:     NewMA.java
 * Project:  MPI Linguistic Application
 * Date:     12 December 2007
 *
 * Copyright (C) 2001-2008  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

package mpi.eudico.client.annotator.commands.global;

import mpi.eudico.client.annotator.ElanFrame2;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.FrameManager;

import mpi.eudico.client.annotator.gui.MultiFileChooser;

import mpi.eudico.client.annotator.linkedmedia.MediaDescriptorUtil;

import mpi.eudico.server.corpora.clom.Transcription;

import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;
import mpi.eudico.server.corpora.clomimpl.type.LinguisticType;

import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;

import java.io.File;

import java.util.Vector;

import javax.swing.Action;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;


/**
 * Action that starts a New Document sequence.
 *
 * @author Han Sloetjes, MPI
 */
public class NewMA extends FrameMenuAction {
    /**
     * Creates a new NewMA instance.
     *
     * @param name the name of the action (command)
     * @param frame the associated frame
     */
    public NewMA(String name, ElanFrame2 frame) {
        super(name, frame);

        putValue(Action.ACCELERATOR_KEY,
            KeyStroke.getKeyStroke(KeyEvent.VK_N,
                Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
    }

    /**
     * Shows a multiple file chooser and creates a new transcription.
     *
     * @param e the action event
     */
    public void actionPerformed(ActionEvent e) {
        Vector mediaDescriptors = new Vector();
        Vector fileNames = null;

        MultiFileChooser chooser = new MultiFileChooser(MultiFileChooser.MEDIA_TEMPLATE);
        chooser.setDialogTitle(ElanLocale.getString(
                "Frame.ElanFrame.NewDialog.Title"));

        int option = chooser.showDialog(frame, null);

        if (option == JFileChooser.APPROVE_OPTION) {
            Object[] files = chooser.getFiles();

            if (files.length > 0) {
                fileNames = new Vector();

                for (int i = 0; i < files.length; i++) {
                    if (fileNames.contains(files[i]) == false) {
                        fileNames.add("" + files[i]);
                    }
                }
            }
        } else {
            return;
        }

        if (fileNames != null) {
            //check if non-existing filenames were entered
            int fileNames_size = fileNames.size();

            for (int i = 0; i < fileNames_size; i++) {
                String strFile = (String) fileNames.elementAt(i);

                if (strFile.startsWith("rtsp")) {
                    continue;
                }

                if ((new File(strFile)).exists() == false) {
                    String strMessage = ElanLocale.getString(
                            "Menu.Dialog.Message1");
                    strMessage += (new File(strFile)).getName();
                    strMessage += ElanLocale.getString("Menu.Dialog.Message2");

                    String strError = ElanLocale.getString("Message.Error");
                    JOptionPane.showMessageDialog(frame, strMessage, strError,
                        JOptionPane.ERROR_MESSAGE);

                    return;
                }
            }

            //get first template file; if there are more template files, rest is not used
            String strTemplate = "";

            for (int i = fileNames_size - 1; i >= 0; i--) {
                String strFile = (String) fileNames.elementAt(i);

                if (strFile.toLowerCase().endsWith(".etf")) {
                    // use the first etf file in the list
                    strTemplate = (String) fileNames.elementAt(i);

                    // remove template files
                    fileNames.remove(i);
                }
            }

            mediaDescriptors = MediaDescriptorUtil.createMediaDescriptors(fileNames);

            // create the Transcription
            Transcription nextTranscription;

            if (strTemplate.equals("")) {
                nextTranscription = new TranscriptionImpl();

                // HS Jan 2007 create a default LinguisticType and Tier
                if ((nextTranscription.getLinguisticTypes().size() == 0) &&
                        (nextTranscription.getTiers().size() == 0)) {
                    // time-alignable, no constraint type
                    LinguisticType type = new LinguisticType("default-lt");
                    TierImpl tier = new TierImpl("default", "",
                            nextTranscription, type);
                    nextTranscription.addLinguisticType(type);
                    nextTranscription.addTier(tier);
                }
            } else {
                nextTranscription = new TranscriptionImpl(new File(strTemplate).getAbsolutePath());
                nextTranscription.setName(TranscriptionImpl.UNDEFINED_FILE_NAME);

                // HS nov 2006: set the pathname to undefined too instead of
                // the path to the template
                ((TranscriptionImpl) nextTranscription).setPathName(TranscriptionImpl.UNDEFINED_FILE_NAME);
            }

            nextTranscription.setMediaDescriptors(mediaDescriptors);

            nextTranscription.setChanged();

            FrameManager.getInstance().createFrame(nextTranscription);
        }
    }
}
