/*
 * File:     OpenMA.java
 * Project:  MPI Linguistic Application
 * Date:     12 December 2007
 *
 * Copyright (C) 2001-2008  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

package mpi.eudico.client.annotator.commands.global;

import mpi.eudico.client.annotator.ElanFrame2;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.FrameManager;
import mpi.eudico.client.annotator.Preferences;

import mpi.eudico.client.annotator.util.ElanFileFilter;

import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;

import java.io.File;

import javax.swing.Action;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;


/**
 * Action that starts a Open Document sequence.
 *
 * @author Han Sloetjes, MPI
 */
public class OpenMA extends FrameMenuAction {
    /**
     * Creates a new OpenMA instance.
     *
     * @param name the name of the action (command)
     * @param frame the associated frame
     */
    public OpenMA(String name, ElanFrame2 frame) {
        super(name, frame);

        putValue(Action.ACCELERATOR_KEY,
            KeyStroke.getKeyStroke(KeyEvent.VK_O,
                Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
    }

    /**
     * Shows an eaf file chooser and creates a new transcription.
     *
     * @param e the action event
     */
    public void actionPerformed(ActionEvent e) {
        JFileChooser chooser = new JFileChooser();
        chooser.setFileFilter(ElanFileFilter.createFileFilter(
                ElanFileFilter.EAF_TYPE));
        chooser.setDialogTitle(ElanLocale.getString(
                "Frame.ElanFrame.OpenDialog.Title"));

        String dirPath = (String) Preferences.get("LastUsedEAFDir", null);

        if (dirPath == null) {
            // user.dir is probably a better choice than home.dir?
            dirPath = System.getProperty("user.dir");
        }

        chooser.setCurrentDirectory(new File(dirPath));

        int returnVal = chooser.showOpenDialog(frame);

        if (returnVal == JFileChooser.APPROVE_OPTION) {
            // check if file exists, don't create a frame when it does not
            try {
                if (chooser.getSelectedFile() == null) {
                    return; // can this occur?
                }

                //check if file exists and is a file
                if (!chooser.getSelectedFile().exists() ||
                        chooser.getSelectedFile().isDirectory()) {
                    String strMessage = ElanLocale.getString(
                            "Menu.Dialog.Message1");
                    strMessage += chooser.getSelectedFile().getAbsolutePath();
                    strMessage += ElanLocale.getString("Menu.Dialog.Message2");

                    String strError = ElanLocale.getString("Message.Error");
                    JOptionPane.showMessageDialog(null, strMessage, strError,
                        JOptionPane.ERROR_MESSAGE);

                    return;
                }
            } catch (Exception exc) {
            }

            Preferences.set("LastUsedEAFDir",
                (new File(chooser.getSelectedFile().getAbsolutePath())).getParent(),
                null);

            FrameManager.getInstance().createFrame(chooser.getSelectedFile()
                                                          .getAbsolutePath());
        }
    }
}
