/*
 * File:     AnnotationTableCellRenderer.java
 * Project:  MPI Linguistic Application
 * Date:     12 December 2007
 *
 * Copyright (C) 2001-2008  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

package mpi.eudico.client.annotator.grid;

import mpi.eudico.client.annotator.Constants;

import mpi.eudico.server.corpora.clom.AnnotationCore;

import java.awt.Component;

import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.SwingConstants;
import javax.swing.border.Border;
import javax.swing.table.TableCellRenderer;


/**
 * Renders annotations in a Table (number, value, times, etc)  Created on Oct
 * 5, 2004
 *
 * @author Alexander Klassmann
 * @version Oct 5, 2004
 */
public class AnnotationTableCellRenderer implements TableCellRenderer {
    /** Holds value of property DOCUMENT ME! */
    protected static final Border marginBorder = BorderFactory.createEmptyBorder(0,
            1, 0, 3);

    /** Holds value of property DOCUMENT ME! */
    protected final JLabel label;

    /**
     * Creates a new AnnotationTableCellRenderer object.
     */
    public AnnotationTableCellRenderer() {
        // override the defaults for performance reasons
        label = new JLabel() {
                    public void validate() {
                    }

                    public void revalidate() {
                    }

                    protected void firePropertyChange(String propertyName,
                        Object oldValue, Object newValue) {
                        // Strings get interned...
                        if (propertyName == "text") {
                            super.firePropertyChange(propertyName, oldValue,
                                newValue);
                        }
                    }

                    public void firePropertyChange(String propertyName,
                        boolean oldValue, boolean newValue) {
                    }
                };
        label.setOpaque(true);
    }

    /* (non-Javadoc)
     * @see javax.swing.table.TableCellRenderer#getTableCellRendererComponent(javax.swing.JTable, java.lang.Object, boolean, boolean, int, int)
     */
    public Component getTableCellRendererComponent(JTable table, Object value,
        boolean isSelected, boolean hasFocus, int row, int column) {
        setComponentLayout(label, table, isSelected);
        setAlignment(label, table.getColumnName(column));

        String renderedText = getRenderedText(value);
        label.setText(renderedText);

        if (!"".equals(renderedText)) {
            label.setToolTipText(renderedText);
        }

        return label;
    }

    /**
     * DOCUMENT ME!
     *
     * @param label DOCUMENT ME!
     * @param columnName DOCUMENT ME!
     */
    protected static void setAlignment(JLabel label, String columnName) {
        if (GridViewerTableModel.COUNT.equals(columnName) ||
                GridViewerTableModel.LEFTCONTEXT.equals(columnName) ||
                GridViewerTableModel.BEGINTIME.equals(columnName) ||
                GridViewerTableModel.ENDTIME.equals(columnName) ||
                GridViewerTableModel.DURATION.equals(columnName)) {
            label.setHorizontalAlignment(SwingConstants.RIGHT);
        } else {
            label.setHorizontalAlignment(SwingConstants.LEFT);
        }
    }

    /**
     * DOCUMENT ME!
     *
     * @param component DOCUMENT ME!
     * @param table DOCUMENT ME!
     * @param isSelected DOCUMENT ME!
     */
    protected static void setComponentLayout(JComponent component,
        JTable table, boolean isSelected) {
        component.setFont(table.getFont());
        component.setBorder(marginBorder);
        component.setBackground(isSelected ? Constants.SELECTIONCOLOR
                                           : table.getBackground());
    }

    /**
     * Handles the drawing of the cells with text values.
     *
     * @param value the value of the table cell
     *
     * @return DOCUMENT ME!
     */
    protected static String getRenderedText(Object value) {
        return ((value instanceof AnnotationCore)
        ? ((AnnotationCore) value).getValue()
        : ((value instanceof String) ? (String) value : ""));
    }
}
