/*
 * File:     StepPane.java
 * Project:  MPI Linguistic Application
 * Date:     12 December 2007
 *
 * Copyright (C) 2001-2008  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

package mpi.eudico.client.annotator.gui.multistep;

import javax.swing.JPanel;


/**
 * StepPane. A Panel representing one of the steps in a multiple step
 * process.
 *
 * @author Han Sloetjes
 */
public class StepPane extends JPanel implements Step {
    /** The MultiStepPane this step is added to */
    protected MultiStepPane multiPane;

    /**
     * Creates a new StepPane instance.
     *
     * @param multiPane the 'parent' pane this step is added to
     */
    public StepPane(MultiStepPane multiPane) {
        super();
        this.multiPane = multiPane;
    }

    /**
     * Initializes the components of the step ui.
     */
    protected void initComponents() {
    }

    /**
     * Returns the title of the step.
     *
     * @return the title of the step
     * @see mpi.eudico.client.tool.viewer.enhanced.multistep.Step#getStepTitle()
     */
    public String getStepTitle() {
        return "";
    }

    /**
     * Notification that this step will become the active step, moving up.
     * The step can perform some preparations.
     *
     * @see mpi.eudico.client.tool.viewer.enhanced.multistep.Step#enterStepForward()
     */
    public void enterStepForward() {
    }

    /**
     * Notification that this step will become the active step, moving down.
     *
     * @see mpi.eudico.client.tool.viewer.enhanced.multistep.Step#enterStepBackward()
     */
    public void enterStepBackward() {
    }

    /**
     * Notification that this step will no longer be the active step, moving up.
     *
     * @see mpi.eudico.client.tool.viewer.enhanced.multistep.Step#leaveStepForward()
     */
    public boolean leaveStepForward() {
        return true;
    }

    /**
     * Notification that this step will no longer be the active step, moving down.
     *
     * @see mpi.eudico.client.tool.viewer.enhanced.multistep.Step#leaveStepBackward()
     */
    public boolean leaveStepBackward() {
        return true;
    }

    /**
     * Called when the process has been cancelled.
     * The step can clean up resources etc.
     *
     * @see mpi.eudico.client.tool.viewer.enhanced.multistep.Step#cancelled()
     */
    public void cancelled() {
    }

    /**
     * Called when to process has finished.
     * The step can clean up etc.
     *
     * @see mpi.eudico.client.tool.viewer.enhanced.multistep.Step#finished()
     */
    public void finished() {
    }

    /**
     * Called when this step should perform the finishing action. The step
     * can delegate the action to one of the other steps.
     *
     * @return true if the process has finishwd successfully, false otherwise
     * @see mpi.eudico.client.tool.viewer.enhanced.multistep.Step#doFinish()
     */
    public boolean doFinish() {
        return true;
    }

    /**
     * Show help information of some form. Or ignore.
     */
    public void showHelp() {
    }
}
