/*
 * File:     ElanMediaPlayer.java
 * Project:  MPI Linguistic Application
 * Date:     12 December 2007
 *
 * Copyright (C) 2001-2008  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

package mpi.eudico.client.annotator.player;

import mpi.eudico.client.annotator.ElanLayoutManager;
import mpi.eudico.client.annotator.ElanLocaleListener;

import mpi.eudico.client.mediacontrol.Controller;


/**
 * The elan media players methods
 */
public interface ElanMediaPlayer extends Controller, ElanLocaleListener {
    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public mpi.eudico.server.corpora.clomimpl.abstr.MediaDescriptor getMediaDescriptor();

    /**
     * DOCUMENT ME!
     */
    public void start();

    /**
     * DOCUMENT ME!
     */
    public void stop();

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public boolean isPlaying();

    /**
     * DOCUMENT ME!
     *
     * @param startTime DOCUMENT ME!
     * @param stopTime DOCUMENT ME!
     */
    public void playInterval(long startTime, long stopTime);

    /**
     * DOCUMENT ME!
     *
     * @param stopTime DOCUMENT ME!
     */
    public void setStopTime(long stopTime);

    /**
     * Sets the new point zero or starting point of the media, in milliseconds
     *
     * @param offset the new point 0
     */
    public void setOffset(long offset);

    /**
     * Returns the offset that has been determined after synchronisation with other media;
     * the new virtual point zero.
     *
     * @return the value of the new starting point, in milliseconds
     */
    public long getOffset();

    /**
     * DOCUMENT ME!
     */
    public void nextFrame();

    /**
     * DOCUMENT ME!
     */
    public void previousFrame();

    /**
     * DOCUMENT ME!
     *
     * @param time DOCUMENT ME!
     */
    public void setMediaTime(long time);

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public long getMediaTime();

    /**
     * Sets the playback rate.
     *
     * @param rate the playback rate
     */
    public void setRate(float rate);

    /**
     * Returns the current playback rate.
     *
     * @return the current playback rate
     */
    public float getRate();

    /**
     * Returns whether or not the framework has successfully detected the encoded framerate and thus
     * the duration per frame.
     *
     * @return true if the framerate has been detected, false otherwise
     */
    public boolean isFrameRateAutoDetected();

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public long getMediaDuration();

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public float getVolume();

    /**
     * DOCUMENT ME!
     *
     * @param level DOCUMENT ME!
     */
    public void setVolume(float level);

    /**
     * DOCUMENT ME!
     *
     * @param layoutManager DOCUMENT ME!
     */
    public void setLayoutManager(ElanLayoutManager layoutManager);

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public java.awt.Component getVisualComponent();

    /**
     * Returns the width in pixels of the media, if it has a visual component.
     *
     * @return the (video) image width, as encoded in the media file, or as interpreted by the
     * framework
     */
    public int getSourceWidth();

    /**
     * Returns the height in pixels of the media, if it has a visual component.
     *
     * @return the (video) image height, as encoded in the media file, or as interpreted by the
     * framework
     */
    public int getSourceHeight();

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public float getAspectRatio();

    /**
     * Returns the frame or sample duration as encoded in the media file (if possible)
     *
     * @return the dample duration in milliseconds
     */
    public long getMilliSecondsPerSample();

    /**
     * Sets the frame duration in case the framework has not detected the sample duration.
     * This value determines the number of ms the playhead moves forward or backward when
     * the frame forward/backward command has been issued.
     *
     * @param milliSeconds the new frame duration
     */
    public void setMilliSecondsPerSample(long milliSeconds); // temporary, player should do this 

    /**
     * DOCUMENT ME!
     */
    public void updateLocale();

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public String getFrameworkDescription();

    /**
     * DOCUMENT ME!
     *
     * @param controller DOCUMENT ME!
     */
    public void addController(Controller controller);

    /**
     * DOCUMENT ME!
     *
     * @param controller DOCUMENT ME!
     */
    public void removeController(Controller controller);

    /**
     * DOCUMENT ME!
     */
    public void startControllers();

    /**
     * DOCUMENT ME!
     */
    public void stopControllers();

    /**
     * DOCUMENT ME!
     *
     * @param time DOCUMENT ME!
     */
    public void setControllersMediaTime(long time);

    /**
     * DOCUMENT ME!
     *
     * @param rate DOCUMENT ME!
     */
    public void setControllersRate(float rate);

    /**
     * Opportunity to dispose of objects, close streams etc. to ensure proper garbage collection.
     */
    public void cleanUpOnClose();
}
