/*
 * File:     PrefKeyMapper.java
 * Project:  MPI Linguistic Application
 * Date:     12 December 2007
 *
 * Copyright (C) 2001-2008  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

package mpi.eudico.client.annotator.prefs;

import java.util.HashMap;


/**
 * A class that maps old preference key values to new key values and vice versa.
 * Introduced with the transition to an xml based preferences storage.
 * (ELAN 3.2)
 *
 * @author Han Sloetjes
 * @version 1.0
 */
public class PrefKeyMapper {
    /** maps old keys to new keys */
    public static HashMap keyMapper;

    static {
        keyMapper = new HashMap(20);
        keyMapper.put("GridMultiMode", "GridViewer.MultiTierMode");
        keyMapper.put("GridTierName", "GridViewer.TierName");
        keyMapper.put("GridFontSize", "GridViewer.FontSize");
        keyMapper.put("TextTierName", "TextViewer.TierName");
        keyMapper.put("TextFontSize", "TextViewer.FontSize");
        keyMapper.put("TextDotSeparated", "TextViewer.DotSeparated");
        keyMapper.put("TextCenterVertical", "TextViewer.CenterVertical");
        keyMapper.put("SubTitleTierName", "SubTitleViewer.TierName-"); // 1 - x
        keyMapper.put("SubTitleFontSize", "SubTitleViewer.FontSize-"); // 1 - x
        keyMapper.put("TimeLineFontSize", "TimeLineViewer.FontSize");
        keyMapper.put("InterlinearFontSize", "InterlinearViewer.FontSize");
        keyMapper.put("TimeSeriesNumPanels", "TimeSeriesViewer.NumPanels");
        keyMapper.put("SelectedTabIndex", "LayoutManager.SelectedTabIndex");
        keyMapper.put("VisibleMultiTierViewer",
            "LayoutManager.VisibleMultiTierViewer");
        keyMapper.put("TierSortingMode", "MultiTierViewer.TierSortingMode");
        keyMapper.put("ActiveTierName", "MultiTierViewer.ActiveTierName");
        keyMapper.put("TierOrder", "MultiTierViewer.TierOrder");
        keyMapper.put("TimeSeriesNumPanels", "TimeSeriesViewer.NumberOfPanels");
        keyMapper.put("SbxMarkerDir", "LastUsedShoeboxMarkerDir");

        //TimeSeriesPanelMap -> TimeSeriesViewer.Panel-x
    }
}
