/*
 * File:     EAFMultipleFileMatch.java
 * Project:  MPI Linguistic Application
 * Date:     12 December 2007
 *
 * Copyright (C) 2001-2008  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

package mpi.eudico.client.annotator.search.result.model;

import mpi.search.content.result.model.AbstractContentMatch;


/**
 * Created on Aug 17, 2004
 * @author Alexander Klassmann
 * @version Aug 17, 2004
 */
public class EAFMultipleFileMatch extends AbstractContentMatch {
    /** Holds value of property DOCUMENT ME! */
    final private String value;
    private String id;

    /**
     * Creates a new EAFMultipleFileMatch instance
     *
     * @param value DOCUMENT ME!
     */
    public EAFMultipleFileMatch(String value) {
        this.value = value;
    }

    /**
     * Creates a new EAFMultipleFileMatch instance
     *
     * @param id DOCUMENT ME!
     * @param value DOCUMENT ME!
     */
    public EAFMultipleFileMatch(String id, String value) {
        this.id = id;
        this.value = value;
    }

    /**
     * DOCUMENT ME!
     *
     * @param s DOCUMENT ME!
     */
    public void setFileName(String s) {
        fileName = s;
    }

    /**
     * DOCUMENT ME!
     *
     * @param s DOCUMENT ME!
     */
    public void setTierName(String s) {
        tierName = s;
    }

    /**
     * DOCUMENT ME!
     *
     * @param s DOCUMENT ME!
     */
    public void setLeftContext(String s) {
        leftContext = s;
    }

    /**
     * DOCUMENT ME!
     *
     * @param s DOCUMENT ME!
     */
    public void setRightContext(String s) {
        rightContext = s;
    }

    /**
     * DOCUMENT ME!
     *
     * @param time DOCUMENT ME!
     */
    public void setBeginTimeBoundary(long time) {
        beginTime = time;
    }

    /**
     * DOCUMENT ME!
     *
     * @param time DOCUMENT ME!
     */
    public void setEndTimeBoundary(long time) {
        endTime = time;
    }

    /* (non-Javadoc)
     * @see mpi.eudico.server.corpora.clom.AnnotationCore#getValue()
     */
    public String getValue() {
        return value;
    }

    /**
     * DOCUMENT ME!
     *
     * @param substringIndices DOCUMENT ME!
     */
    public void setMatchedSubstringIndices(int[][] substringIndices) {
        this.matchedSubstringIndices = substringIndices;
    }

    /**
     * DOCUMENT ME!
     *
     * @param id DOCUMENT ME!
     */
    public void setId(String id) {
        this.id = id;
    }

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public String getId() {
        return id;
    }
}
