/*
 * File:     SVGAnnotationDataRecord.java
 * Project:  MPI Linguistic Application
 * Date:     12 December 2007
 *
 * Copyright (C) 2001-2008  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

package mpi.eudico.client.annotator.svg;

import mpi.eudico.client.annotator.util.AnnotationDataRecord;

import mpi.eudico.server.corpora.clomimpl.abstr.SVGAlignableAnnotation;

import java.awt.Shape;


/**
 * A class to store annotation data that are essential for the programmatic
 * re-creation of an annotation. Extends <code>AnnotationDataRecord</code> by
 * optionally storing a graphical Shape object.
 *
 * @author Han Sloetjes
 */
public class SVGAnnotationDataRecord extends AnnotationDataRecord {
    /** Stores the shape object */
    protected Shape shape;

    /** stores the svg element id */
    protected String svgElementId;

    /**
     * Creates an AnnotationData object from the specified Annotation.
     *
     * @param annotation the Annotation
     */
    public SVGAnnotationDataRecord(SVGAlignableAnnotation annotation) {
        super(annotation);

        shape = annotation.getShape();
        svgElementId = annotation.getSVGElementID();
    }

    /**
     * Returns the Shape object.
     *
     * @return the Shape object which can be null
     */
    public Shape getShape() {
        return shape;
    }

    /**
     * Returns the element id.
     *
     * @return the element id or null
     */
    public String getSvgElementId() {
        return svgElementId;
    }
}
