/*
 * File:     Test.java
 * Project:  MPI Linguistic Application
 * Date:     12 December 2007
 *
 * Copyright (C) 2001-2008  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

package mpi.eudico.client.annotator.tier;

import mpi.eudico.client.annotator.commands.ELANCommandFactory;

import mpi.eudico.client.annotator.gui.multistep.MultiStepPane;
import mpi.eudico.client.annotator.gui.multistep.StepPane;

import mpi.eudico.server.corpora.clom.Transcription;

import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;

import javax.swing.JDialog;
import javax.swing.WindowConstants;


/**
 * Test class.
 *
 * @author Han Sloetjes
 * @version 1.0
 */
public class Test {
    private TranscriptionImpl trans;

    /**
     * Creates a new Test instance
     *
     * @param t DOCUMENT ME!
     */
    public Test(Transcription t) {
        trans = (TranscriptionImpl) t;
    }

    /**
     * DOCUMENT ME!
     */
    public void test() {
        MultiStepPane pane = new MultiStepPane();
        StepPane step1 = new CopyTierStep1(pane, trans);
        StepPane step2 = new CopyTierStep2(pane, trans);
        StepPane step3 = new CopyTierStep3(pane, trans);
        pane.addStep(step1);
        pane.addStep(step2);
        pane.addStep(step3);

        JDialog dialog = pane.createDialog(ELANCommandFactory.getRootFrame(
                    trans), "Reparent test", true);

        //dialog.setDefaultCloseOperation(WindowConstants.DO_NOTHING_ON_CLOSE);
        //dialog.pack();
        dialog.setVisible(true);
    }
}
