/*
 * File:     ExtractDataMultiStep.java
 * Project:  MPI Linguistic Application
 * Date:     12 December 2007
 *
 * Copyright (C) 2001-2008  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

package mpi.eudico.client.annotator.timeseries;

import mpi.eudico.client.annotator.ElanLocale;

import mpi.eudico.client.annotator.commands.ELANCommandFactory;

import mpi.eudico.client.annotator.gui.multistep.MultiStepPane;
import mpi.eudico.client.annotator.gui.multistep.StepPane;

import mpi.eudico.client.annotator.util.ClientLogger;

import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;

import javax.swing.JDialog;


/**
 * DOCUMENT ME!
 * $Id: jalopy_gnu_src_dist.xml 11222 2007-12-11 15:57:47Z hasloe $
 * @author $Author$
 * @version $Revision$
 */
public class ExtractDataMultiStep implements ClientLogger {
    /**
     * Creates a new ExtractDataMultiStep instance
     *
     * @param transcription DOCUMENT ME!
     * @param manager DOCUMENT ME!
     */
    public ExtractDataMultiStep(TranscriptionImpl transcription,
        TSTrackManager manager) {
        show(transcription, manager);
    }

    private void show(TranscriptionImpl transcription, TSTrackManager manager) {
        if (transcription == null) {
            LOG.warning(
                "Could not create multistep dialog: transcription is null");

            return;
        }

        if (transcription == null) {
            LOG.warning("Could not create multistep dialog: manager is null");

            return;
        }

        MultiStepPane pane = new MultiStepPane(ElanLocale.getResourceBundle());

        StepPane step1 = new ExtractStep1(pane, transcription);
        StepPane step2 = new ExtractStep2(pane, transcription, manager);
        StepPane step3 = new ExtractStep3(pane, transcription, manager);
        pane.addStep(step1);
        pane.addStep(step2);
        pane.addStep(step3);

        JDialog dialog = pane.createDialog(ELANCommandFactory.getRootFrame(
                    transcription),
                ElanLocale.getString("TimeSeriesViewer.Extract"), true);

        dialog.setVisible(true);
    }
}
