/*
 * File:     TSRuler.java
 * Project:  MPI Linguistic Application
 * Date:     12 December 2007
 *
 * Copyright (C) 2001-2008  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

package mpi.eudico.client.annotator.timeseries;

import java.awt.Color;
import java.awt.Font;


/**
 * Interface describing a vertical ruler for time series data viewers.
 */
public interface TSRuler {
    /**
     * Returns the current range, min - max.
     *
     * @return the current min and max value of the ruler
     */
    public float[] getRange();

    /**
     * Sets the current range, min - max.
     *
     * @param range the new range
     */
    public void setRange(float[] range);

    /**
     * Returns a String representation of the ruler's units, like m/s.
     *
     * @return a String representation of the ruler's units
     */
    public String getUnitString();

    /**
     * Sets the String representation of the ruler's units.
     *
     * @param unitString the String representation of the ruler's units
     */
    public void setUnitString(String unitString);

    /**
     * Returns the height in pixels of the ruler.
     *
     * @return the height
     */
    public int getHeight();

    /**
     * Sets the height in pixels of the ruler.
     *
     * @param height the height in pixels of the ruler
     */
    public void setHeight(int height);

    /**
     * Returns the width of the ruler area.
     *
     * @return the width of the ruler
     */
    public int getWidth();

    /**
     * Sets the width of the ruler area.
     *
     * @param width the new width
     */
    public void setWidth(int width);

    /**
     * Sets the Color for tick markers and labels. Default is black.
     *
     * @param color the Color for tick markers and labels
     */
    public void setForegroundColor(Color color);

    /**
     * Returns the Color for tick markers and labels.
     *
     * @return the Color for tick markers and labels
     */
    public Color getForegroundColor();

    /**
     * Sets the font for labels.
     *
     * @param font the font for the labels
     */
    public void setFont(Font font);

    /**
     * Returns the font used for the lables.
     *
     * @return the font for the labels
     */
    public Font getFont();

    /**
     * Sets the size for the label font.
     *
     * @param size the size for the font
     */
    public void setFontSize(float size);

    /**
     * Returns the size of the font.
     *
     * @return the size of the font
     */
    public float getFontSize();
}
