/*
 * File:     TSConfigurationImpl.java
 * Project:  MPI Linguistic Application
 * Date:     12 December 2007
 *
 * Copyright (C) 2001-2008  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

package mpi.eudico.client.annotator.timeseries.config;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Properties;
import java.util.Set;


/**
 * Default implementation of TSConfiguration.
 *
 * @author Han Sloetjes
 */
public class TSConfigurationImpl implements TSConfiguration {
    /** the properties */
    protected Properties properties;

    /** a map for configuration or track objects */
    protected HashMap objectMap;

    /**
     * Creates a new TSConfigurationImpl instance
     */
    public TSConfigurationImpl() {
        properties = new Properties();
        objectMap = new HashMap();
    }

    /**
     * @see mpi.eudico.server.timeseries.TSConfiguration#setProperty(java.lang.String,
     *      java.lang.String)
     */
    public void setProperty(String key, String value) {
        properties.setProperty(key, value);
    }

    /**
     * @see mpi.eudico.server.timeseries.TSConfiguration#getProperty(java.lang.String)
     */
    public String getProperty(String key) {
        return properties.getProperty(key);
    }

    /**
     * @see mpi.eudico.server.timeseries.TSConfiguration#removeProperty(java.lang.String)
     */
    public Object removeProperty(String key) {
        return properties.remove(key);
    }

    /**
     * @see mpi.eudico.server.timeseries.TSConfiguration#propertyNames()
     */
    public Enumeration propertyNames() {
        return properties.propertyNames();
    }

    /**
     * @see mpi.eudico.server.timeseries.TSConfiguration#putObject(java.lang.Object,
     *      java.lang.Object)
     */
    public void putObject(Object key, Object value) {
        objectMap.put(key, value);
    }

    /**
     * @see mpi.eudico.server.timeseries.TSConfiguration#getObject(java.lang.Object)
     */
    public Object getObject(Object key) {
        return objectMap.get(key);
    }

    /**
     * @see mpi.eudico.server.timeseries.TSConfiguration#removeObject(java.lang.Object)
     */
    public Object removeObject(Object key) {
        return objectMap.remove(key);
    }

    /**
     * @see mpi.eudico.server.timeseries.TSConfiguration#objectKeys()
     */
    public Set objectKeySet() {
        return objectMap.keySet();
    }
}
