/*
 * File:     DataGloveConstants.java
 * Project:  MPI Linguistic Application
 * Date:     12 December 2007
 *
 * Copyright (C) 2001-2008  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

package mpi.eudico.client.annotator.timeseries.glove;

/**
 * DOCUMENT ME!
 * $Id: jalopy_gnu_src_dist.xml 11222 2007-12-11 15:57:47Z hasloe $
 * @author $Author$
 * @version $Revision$
 */
public interface DataGloveConstants {
    // knowledge about the rows and columns in the samples
    // mandatory are 15 rows, optionally followed by 20 rows of finger coords

    /** number of columns for all possible 35 rows;
     * the first 15 rows vary, all other rows have 4 columns */
    public final int[] COLS_PER_ROW = new int[] {
            3, 3, 3, 3, 3, 3, 4, 3, 3, 4, 6, 4, 6, 4, 6, 4, 4, 4, 4, 4, 4, 4, 4,
            4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4
        };

    /**  the minimal number of rows per sample */
    public final int MIN_NUM_ROWS = 15;

    /** the maximum number of rows per sample */
    public final int MAX_NUM_ROWS = 35;

    // provide a matrix of descriptions per cell
}
