/*
 * File:     AnnotationDataFlavor.java
 * Project:  MPI Linguistic Application
 * Date:     12 December 2007
 *
 * Copyright (C) 2001-2008  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

package mpi.eudico.client.annotator.util;

import java.awt.datatransfer.DataFlavor;


/**
 * A DataFlavor for AnnotationDataRecords (Singleton).
 */
public class AnnotationDataFlavor extends DataFlavor implements ClientLogger {
    private static AnnotationDataFlavor flavor = null;

    /**
     * Creates a new AnnotationDataFlavor instance
     *
     * @throws ClassNotFoundException DOCUMENT ME!
     */
    private AnnotationDataFlavor() throws ClassNotFoundException {
        super(DataFlavor.javaSerializedObjectMimeType + ";class=" +
            AnnotationDataRecord.class.getName());
    }

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public static AnnotationDataFlavor getInstance() {
        if (flavor == null) {
            createFlavor();
        }

        return flavor;
    }

    private static void createFlavor() {
        try {
            flavor = new AnnotationDataFlavor();
        } catch (ClassNotFoundException cnfe) {
            LOG.warning("Flavor class not found: " + cnfe.getMessage());
        }
    }
}
