/*
 * File:     AnnotationTreeDataFlavor.java
 * Project:  MPI Linguistic Application
 * Date:     12 December 2007
 *
 * Copyright (C) 2001-2008  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

package mpi.eudico.client.annotator.util;

import java.awt.datatransfer.DataFlavor;

import javax.swing.tree.DefaultMutableTreeNode;


/**
 * A DataFlavor for annotation tree DefaultMutableTreeNodes  (Singleton).
 */
public class AnnotationTreeDataFlavor extends DataFlavor implements ClientLogger {
    private static AnnotationTreeDataFlavor flavor = null;

    /**
     * Creates a new AnnotationTreeDataFlavor instance
     *
     * @throws ClassNotFoundException DOCUMENT ME!
     */
    private AnnotationTreeDataFlavor() throws ClassNotFoundException {
        super(DataFlavor.javaSerializedObjectMimeType + ";class=" +
            DefaultMutableTreeNode.class.getName());
    }

    /**
     * Returns the single instance of AnnotationTreeDataFlavor.
     *
     * @return the single instance of AnnotationTreeDataFlavor
     */
    public static AnnotationTreeDataFlavor getInstance() {
        if (flavor == null) {
            createFlavor();
        }

        return flavor;
    }

    private static void createFlavor() {
        try {
            flavor = new AnnotationTreeDataFlavor();
        } catch (ClassNotFoundException cnfe) {
            LOG.warning("Flavor class not found: " + cnfe.getMessage());
        }
    }
}
