/*
 * File:     FrameConstants.java
 * Project:  MPI Linguistic Application
 * Date:     12 December 2007
 *
 * Copyright (C) 2001-2008  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

package mpi.eudico.client.annotator.util;


/**
 * Specifies a number of constants for ELAN frames.
 *
 * @author Han Sloetjes, MPI
 */
public interface FrameConstants {
    // menu constants

    /** the file menu */
    public static final int FILE = 0;

    /** the edit menu */
    public static final int EDIT = 100;

    /** the annotation menu */
    public static final int ANNOTATION = 200;

    /** the tier menu */
    public static final int TIER = 300;

    /** the type menu */
    public static final int TYPE = 400;

    /** the search menu */
    public static final int SEARCH = 500;

    /** the view menu */
    public static final int VIEW = 600;

    /** the options menu */
    public static final int OPTION = 700;

    /** the window menu */
    public static final int WINDOW = 800;

    /** the help menu */
    public static final int HELP = 900;

    /** the recent files menu */
    public static final int RECENT = 11;

    /** the export menu */
    public static final int EXPORT = 12;

    /** the import menu */
    public static final int IMPORT = 13;

    /** the propagation menu */
    public static final int PROPAGATION = 801;

    /** the language menu */
    public static final int LANG = 860;

    /** the video standard menu, or frame length */
    public static final int FRAME_LENGTH = 840;

    /** the annotation mode menu */
    public static final int ANNOTATION_MODE = 810;

    /** the media synchronisation mode menu */
    public static final int SYNC_MODE = 811;

    /** the kiosk mode menu */
    public static final int KIOSK_MODE = 812;

    /** the play around selection dialog menu */
    public static final int PLAY_AROUND_SEL = 813;

    /** the rate volume toggle value menu */
    public static final int RATE_VOL_TOGGLE = 814;

    /** the maximum size of the recent files list */
    public final int MAX_NUM_RECENTS = 5;
}
