/*
 * File:     IPAGIMToHTML.java
 * Project:  MPI Linguistic Application
 * Date:     12 December 2007
 *
 * Copyright (C) 2001-2008  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

package mpi.eudico.client.annotator.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStreamWriter;

import java.util.StringTokenizer;


/**
 * DOCUMENT ME!
 * $Id: jalopy_gnu_src_dist.xml 11222 2007-12-11 15:57:47Z hasloe $
 * @author $Author$
 * @version $Revision$
 */
public class IPAGIMToHTML {
    /** Holds value of property DOCUMENT ME! */
    String res = "/src/resources/guk/im/data/ipa-extension.gim";

    /**
     * Creates a new IPAGIMToHTML instance
     */
    public IPAGIMToHTML() {
        convert();
        System.out.println("Conversion completed");
    }

    /**
     * DOCUMENT ME!
     */
    public void convert() {
        String sourceFile = System.getProperty("user.dir") + res;
        String outFile = sourceFile.replaceFirst("gim", "html");

        try {
            // in
            FileReader fileRead = new FileReader(sourceFile);
            BufferedReader bufRead = new BufferedReader(fileRead);

            // out
            FileOutputStream out = new FileOutputStream(outFile);
            OutputStreamWriter osw = new OutputStreamWriter(out, "UTF-8");
            BufferedWriter writer = new BufferedWriter(osw);

            writer.write(
                "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\" \"http://www.w3.org/TR/1999/REC-html401-19991224/loose.dtd\">");
            writer.write(
                "\n<html><head><title>MPI - IPA extended keyboard mapping</title></head>\n");
            writer.write(
                "<body>\n<h3>MPI - IPA extended keyboard mapping (GUK)</h3>\n");
            writer.write("<table>\n");
            writer.write(
                "<tr><th align=\"left\" width=\"120\">Key sequence</th><th align=\"left\" width=\"120\">Unicode code</th><th align=\"left\">IPA character</th></tr>\n");

            String li = null;
            char ch = '1';
            StringTokenizer tokenizer;
            String code;
            int index = 0;

            while ((li = bufRead.readLine()) != null) {
                index++;

                if ((li.length() == 0) || (index < 120)) {
                    continue; //empty line
                } else {
                    if (li.charAt(0) == '#') {
                        continue; //comment line
                    }

                    tokenizer = new StringTokenizer(li);

                    if (tokenizer.countTokens() == 4) {
                        tokenizer.nextToken();
                        code = tokenizer.nextToken();

                        if (code.length() > 1) {
                            if (code.charAt(1) != ch) {
                                // insert empty row
                                writer.write(
                                    "<tr><td colspan=\"3\">&nbsp;</td></tr>\n");
                                ch = code.charAt(1);
                            }
                        }

                        writer.write("<tr><td>");
                        writer.write(code + "</td><td>");
                        tokenizer.nextToken();
                        code = tokenizer.nextToken();
                        writer.write(code + "</td><td>");
                        writer.write("&#" + code.substring(1) + ";");
                        writer.write("</td></tr>\n");
                    }
                }
            }

            writer.write("</table></body></html>");
            writer.flush();

            try {
                bufRead.close();
                writer.close();
            } catch (IOException ioe) {
                System.out.println("Could not close a stream...");
                ioe.printStackTrace();
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    /**
     * DOCUMENT ME!
     *
     * @param args DOCUMENT ME!
     */
    public static void main(String[] args) {
        new IPAGIMToHTML();
    }
}
