/*
 * File:     ControllerManager.java
 * Project:  MPI Linguistic Application
 * Date:     12 December 2007
 *
 * Copyright (C) 2001-2008  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

package mpi.eudico.client.mediacontrol;

import java.util.Vector;


/**
 * A ControllerManager takes care of informing interested Controllers about
 * media related events
 */
public class ControllerManager extends EventPostingBase {
    private Vector controllers;
    private boolean controllersAreStarted;

    /**
     *
     */
    public ControllerManager() {
        controllers = new Vector();
        controllersAreStarted = false;
    }

    /**
     * Add a Controller that has to be managed
     *
     * @param controller DOCUMENT ME!
     */
    public synchronized void addController(Controller controller) {
        if (!controllers.contains(controller)) {
            controllers.add(controller);
        }
    }

    /**
     * Remove a Controller that no longer has to be managed
     *
     * @param controller DOCUMENT ME!
     */
    public synchronized void removeController(Controller controller) {
        controllers.remove(controller);
    }

    /**
     * Start all managed Controllers
     */
    public void startControllers() {
        if (!controllersAreStarted) {
            for (int i = 0; i < controllers.size(); i++) {
                ((Controller) controllers.elementAt(i)).start();
            }

            controllersAreStarted = true;
        }
    }

    /**
     * Stop all managed Controllers
     */
    public void stopControllers() {
        if (controllersAreStarted) {
            for (int i = 0; i < controllers.size(); i++) {
                ((Controller) controllers.elementAt(i)).stop();
            }

            controllersAreStarted = false;
        }
    }

    /**
     * Set the stop time for all managed Controllers
     *
     * @param time DOCUMENT ME!
     */
    public void setControllersStopTime(long time) {
        for (int i = 0; i < controllers.size(); i++) {
            ((Controller) controllers.elementAt(i)).setStopTime(time);
        }
    }

    /**
     * Set the media time for all managed Controllers
     *
     * @param time DOCUMENT ME!
     */
    public void setControllersMediaTime(long time) {
        for (int i = 0; i < controllers.size(); i++) {
            ((Controller) controllers.elementAt(i)).setMediaTime(time);
        }
    }

    /**
     * Set the rate for all managed Controllers
     *
     * @param rate DOCUMENT ME!
     */
    public void setControllersRate(float rate) {
        for (int i = 0; i < controllers.size(); i++) {
            ((Controller) controllers.elementAt(i)).setRate(rate);
        }
    }
}
