/*
 * File:     CheckBoxTableCellRenderer.java
 * Project:  MPI Linguistic Application
 * Date:     12 December 2007
 *
 * Copyright (C) 2001-2008  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

package mpi.eudico.client.util;

import java.awt.Component;

import javax.swing.JCheckBox;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;


/**
 * A table cell renderer that uses a JCheckBox to render a boolean  value in a
 * table cell.
 *
 * @author Han Sloetjes
 */
public class CheckBoxTableCellRenderer extends JCheckBox
    implements TableCellRenderer {
    /**
     * Constructor. Calls super().
     */
    public CheckBoxTableCellRenderer() {
        super();
        setOpaque(true);
    }

    /**
     * Returns the component.
     *
     * @see javax.swing.ListCellRenderer#getListCellRendererComponent(javax.swing.JList,
     *      java.lang.Object, int, boolean, boolean)
     */
    public Component getTableCellRendererComponent(JTable table, Object value,
        boolean isSelected, boolean hasFocus, int row, int column) {
        if (isSelected) {
            super.setBackground(table.getSelectionBackground());
        } else {
            super.setBackground(table.getBackground());
        }

        if (value instanceof Boolean) {
            super.setSelected(((Boolean) value).booleanValue());
        } else if (value instanceof String) {
            super.setSelected(((String) value).equalsIgnoreCase("true"));
        }

        return this;
    }
}
