/*
 * File:     PathTest.java
 * Project:  MPI Linguistic Application
 * Date:     12 December 2007
 *
 * Copyright (C) 2001-2008  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

package mpi.eudico.client.util;

import java.io.File;
import java.io.IOException;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;


/**
 * DOCUMENT ME!
 * $Id: jalopy_gnu_src_dist.xml 11222 2007-12-11 15:57:47Z hasloe $
 * @author $Author$
 * @version $Revision$
 */
public class PathTest {
    /**
     *
     */
    public PathTest() {
        super();
        test();
    }

    private void test() {
        System.out.println("Current dir: " + System.getProperty("user.dir"));

        File f = new File("../..");

        try {
            System.out.println("File exists: " + f.exists());
            System.out.println("Abs File: " + f.getAbsoluteFile());
            System.out.println("Can File: " + f.getCanonicalFile());
            System.out.println("Abs Path: " + f.getAbsolutePath());
            System.out.println("Can Path: " + f.getCanonicalPath());
            System.out.println("Parent: " +
                f.getParentFile().getCanonicalPath());

            try {
                URI uri = new URI(f.getCanonicalPath().replace('\\', '/'));
                System.out.println("URI: " + uri.getPath());

                URL url = new URL("file:///../../build.xml");
                System.out.println("URL: " + url.toExternalForm());

                URL url2 = new URL("file", null, 0, "../../build.xml");
                System.out.println("URL2: " + url2.toExternalForm());

                //URL url3 = uri.toURL();
                //System.out.println("URI 2 URL: " + url3.toExternalForm());
                URI uri2 = new URI(new File(
                            "D:/temp/daag/Dev_LAT_SVN/build.xml").getCanonicalPath()
                                                                                 .replace('\\',
                            '/'));
                URI uri3 = new URI(new File("D:/temp/Chintang.imdi").getCanonicalPath()
                                                                    .replace('\\',
                            '/'));
                System.out.println("Rel. path: " +
                    uri2.relativize(uri3).getPath());
            } catch (MalformedURLException mue) {
                mue.printStackTrace();
            } catch (URISyntaxException uise) {
                uise.printStackTrace();
            }
        } catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    /**
     * @param args
     */
    public static void main(String[] args) {
        new PathTest();
    }
}
