/*
 * File:     TableSubHeaderObject.java
 * Project:  MPI Linguistic Application
 * Date:     12 December 2007
 *
 * Copyright (C) 2001-2008  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

package mpi.eudico.client.util;


/**
 * An object that encapsulates an Object, typically a String, and that is used to identify
 * a "sub header" table cell in a JTable.
 */
public class TableSubHeaderObject {
    private Object content;

    /**
     * Creates a new TableSubHeaderObject instance.
     *
     * @param content the content of this object
     */
    public TableSubHeaderObject(Object content) {
        super();
        this.content = content;
    }

    /**
     * Returns the content of this object.
     *
     * @return Returns the content.
     */
    public Object getContent() {
        return content;
    }

    /**
     * Sets the content.
     *
     * @param content The content to set.
     */
    public void setContent(Object content) {
        this.content = content;
    }

    /**
     * Returns the content as a String.
     *
     * @return the content as a String
     */
    public String toString() {
        if (content != null) {
            return content.toString();
        } else {
            return "";
        }
    }
}
