<?xml version="1.0" encoding="ISO-8859-1"?>

<!-- 
     This stylesheet creates for an alignable tier out of an EAF-file subtitles for 
     the audio or video resource.
     It's output comprises
     - an 'rt' (Real-Text) file containing the text and time of all annotations in the tier.

     The tier has to be specified as command line parameter in the form "-param tier [tier-ID]"

     Author: Alexander Klassmann
     Version: 1.0.beta 
-->

<!DOCTYPE xsl:stylesheet >
<xsl:stylesheet version="1.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

  <xsl:output method="xml" indent="yes" omit-xml-declaration="yes" encoding="ISO-8859-1"/>
  <xsl:strip-space elements="*"/>


  <!--   Possible command line parameters   -->
  
  <!-- if no tier specified choose the first one -->
  <xsl:param name="tier" select="/ANNOTATION_DOCUMENT/TIER[1]/@TIER_ID"/>

  <!-- colours -->
  <xsl:param name="subtitle_background_color" select="'#E6E6E6'"/>

  <!-- font size (defined like in HTML) -->
  <xsl:param name="font_size" select="3"/>

  <!-- intervall to be displayed (and annotations to be extracted) -->
  <xsl:param name="media_start_time" select="0"/>
  <xsl:param name="media_stop_time" select="16777216"/>
  
  <xsl:template match="/ANNOTATION_DOCUMENT"> 
    <xsl:element name="window">
      <xsl:attribute name="type">generic</xsl:attribute>
      <xsl:attribute name="bgcolor">
        <xsl:value-of select="$subtitle_background_color"/>
      </xsl:attribute>
      <xsl:element name="font">
	    <xsl:attribute name="size">
          <xsl:value-of select="$font_size"/>
        </xsl:attribute>
        <xsl:attribute name="color">black</xsl:attribute>
        <xsl:attribute name="face">Arial</xsl:attribute>
        <xsl:element name="center">
          <xsl:element name="b">
            <xsl:value-of select="$tier"/>
          </xsl:element>
        </xsl:element>
        <xsl:apply-templates select="./TIER[@TIER_ID=$tier]"/>
      </xsl:element>
    </xsl:element>
  </xsl:template>
  
  <xsl:template match="//TIER">
    <xsl:apply-templates select="./ANNOTATION"/>
  </xsl:template>
  
  <xsl:template match="ANNOTATION">
  
    <xsl:choose>
      <xsl:when test="ALIGNABLE_ANNOTATION">
        <xsl:call-template name="get-time">
          <xsl:with-param name="alignable_annotation" select="ALIGNABLE_ANNOTATION"/>
          <xsl:with-param name="annotation_value" select="child::node()/ANNOTATION_VALUE"/>
        </xsl:call-template>
      </xsl:when>
      <xsl:otherwise>
        <xsl:call-template name="get-time-for-ref-annotation">
          <xsl:with-param name="annotation_ref" select="REF_ANNOTATION/@ANNOTATION_REF"/>
          <xsl:with-param name="annotation_value" select="child::node()/ANNOTATION_VALUE"/>
        </xsl:call-template>        
      </xsl:otherwise>
    </xsl:choose>
      
  </xsl:template>
  
  <xsl:template name="get-time-for-ref-annotation">
    <xsl:param name="annotation_ref"/>
    <xsl:param name="annotation_value"/>
    <xsl:variable name="annotation" select="//ANNOTATION/child::node()[@ANNOTATION_ID=$annotation_ref]"/>
    <xsl:choose>
      <xsl:when test="$annotation/@ANNOTATION_REF">
        <xsl:call-template name="get-time-for-ref-annotation">
          <xsl:with-param name="annotation_ref" select="$annotation/@ANNOTATION_REF"/>
          <xsl:with-param name="annotation_value" select="$annotation_value"/>
        </xsl:call-template>
      </xsl:when>
      <xsl:otherwise>
        <xsl:call-template name="get-time">
          <xsl:with-param name="alignable_annotation" select="$annotation"/>
          <xsl:with-param name="annotation_value" select="$annotation_value"/>
        </xsl:call-template>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>

  <xsl:template name="get-time">
    <xsl:param name="alignable_annotation"/>
    <xsl:param name="annotation_value"/>
    <xsl:variable name="time_slot_id">
      <xsl:value-of select="$alignable_annotation/@TIME_SLOT_REF1"/>
    </xsl:variable>
    <xsl:variable name="annotation_begin_time">
      <xsl:value-of select="//TIME_SLOT[@TIME_SLOT_ID=$time_slot_id]/@TIME_VALUE"/>
    </xsl:variable>
    <xsl:variable name="time_slot_id">
      <xsl:value-of select="$alignable_annotation/@TIME_SLOT_REF2"/>
    </xsl:variable>
    <xsl:variable name="annotation_end_time">
      <xsl:value-of select="//TIME_SLOT[@TIME_SLOT_ID=$time_slot_id]/@TIME_VALUE"/>
    </xsl:variable>
    
    <xsl:if test="not($annotation_end_time &lt; $media_start_time or $annotation_begin_time &gt; $media_stop_time)">
      <xsl:element name="time">
        <xsl:attribute name="begin">
          <xsl:value-of select="$annotation_begin_time div 1000"/>
        </xsl:attribute>
        <xsl:attribute name="end">
          <xsl:value-of select="$annotation_end_time div 1000"/>
        </xsl:attribute>
      </xsl:element>
	<xsl:element name="pos">
		<xsl:attribute name="x">
			<xsl:value-of select="0"/>
		</xsl:attribute>
		<xsl:attribute name="y">
			<xsl:value-of select="18"/>
		</xsl:attribute>
	</xsl:element>
      <xsl:value-of select="$annotation_value"/>
    </xsl:if>
  </xsl:template>
  
</xsl:stylesheet>




