/*
 * File:     AnnotationDocEncoder.java
 * Project:  MPI Linguistic Application
 * Date:     12 December 2007
 *
 * Copyright (C) 2001-2008  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

/*
 * Created on Oct 12, 2004
 *
 */
package mpi.eudico.server.corpora.clom;

import java.io.IOException;

import java.util.List;


/**
 * To be implemented for every annotation document format that is to
 * be written. Used by TranscriptionStore to encode and write to the
 * desired output format.
 *
 * @author hennie
 *
 */
public interface AnnotationDocEncoder {
    /**
     * DOCUMENT ME!
     *
     * @param theTranscription DOCUMENT ME!
     * @param theEncoderInfo DOCUMENT ME!
     * @param tierOrder DOCUMENT ME!
     * @param path DOCUMENT ME!
     *
     * @throws IOException DOCUMENT ME!
     */
    public void encodeAndSave(Transcription theTranscription,
        EncoderInfo theEncoderInfo, List tierOrder, String path)
        throws IOException;
}
