/*
 * File:     MediaObject.java
 * Project:  MPI Linguistic Application
 * Date:     12 December 2007
 *
 * Copyright (C) 2001-2008  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

package mpi.eudico.server.corpora.clom;

import mpi.eudico.server.corpora.event.DurationUnknownException;
import mpi.eudico.server.corpora.event.NoAudioSampleDataException;
import mpi.eudico.server.corpora.event.NoMediaFileException;

import java.net.URL;


/**
 * MediaObject encapsulates all information about media objects on a media
 * server that is used by the EUDICO data objects. Each Transcription is
 * associated with a MediaObject.
 *
 * @author Hennie Brugman
 * @author Albert Russel
 * @version 2-Jun-1999
 */

// 10 0ct 2000; Daan Broeder; made it a LanguageResource
public interface MediaObject extends LanguageResource {
    /** Holds value of property DOCUMENT ME! */
    public static int PAL = 1;

    /** Holds value of property DOCUMENT ME! */
    public static int NTSC = 2;

    /**
     * Returns a name identitying a media file or media stream.
     *
     * @return    the media file or stream name
     * @exception     NoMediaFileException    thrown when a video file is unknown or
     *                    not available for this MediaObject
     */
    public String getMediaFile() throws NoMediaFileException;

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public URL getMediaURL();

    /**
     * Returns a name identitying an audio sample data file or stream.
     *
     * @return    the audio file or stream name
     * @exception     NoAudioSampleDataException    thrown when an audio file is unknown or
     *                        not available for this MediaObject
     */
    public String getAudioSampleData() throws NoAudioSampleDataException;

    /**
     * Returns the Duration of the MediaObject in milliseconds.
     *
     * @return    the duration in milliseconds
     * @exception     DurationUnknownException    thrown if duration is unknown or
     *                    otherwise unavailable
     */
    public long getDuration() throws DurationUnknownException;

    /**
     * Returns the sample rate of a media object. (examples: 25 for PAL video,
     * 29.97 for NTSC video, 44100, ... for audio.
     */
    public double getMediaSampleRate();
}
