/*
 * File:     TierSetupDatabase.java
 * Project:  MPI Linguistic Application
 * Date:     12 December 2007
 *
 * Copyright (C) 2001-2008  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

package mpi.eudico.server.corpora.clom;


/**
 * TierSetupDatabase is intended to provide a single access point for tier
 * setup information as TierBundles, TierSharedInfo objects and CodeTypes that
 * are available for a specific corpus. These objects can exist independent of
 * the existence of objects in the Data Tree  (DataTreeNodes). Because
 * TierSetupDatabase is a single access point, it has to be implemented
 * (possibly for each implementing corpus) as a Singleton.
 *
 * @author Hennie Brugman
 * @author Albert Russel
 * @version 28-May-1998
 */
public interface TierSetupDatabase {
    //	public Set getCodeTypes();
}
