/*
 * File:     TreeViewable.java
 * Project:  MPI Linguistic Application
 * Date:     12 December 2007
 *
 * Copyright (C) 2001-2008  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

package mpi.eudico.server.corpora.clom;

import java.util.Vector;


/**
 * If an Object implements the TreeViewable interface it can be  used as a
 * content Object of a DynamicTreeNode.
 *
 * @author Hennie Brugman
 * @author Albert Russel
 * @version 06-Mai-1998
 */
public interface TreeViewable {
    /**
     * Returns the name of the TreeViewable Object as it must be used in the
     * Tree.
     *
     * @return the name of the TreeViewable
     */
    public String getNodeName();

    /**
     * Informs whether this TreeViewable has TreeViewable children.
     *
     * @return true if this TreeViewable has TreeViewable children, false
     *         otherwise
     */
    public boolean isTreeViewableLeaf();

    /**
     * Returns a Vector with the TreeViewable children of this TreeViewable. If
     * this TreeViewable has no children an empty Vector must be returned
     * instead of null.
     *
     * @return the TreeViewable children
     */
    public Vector getChildren();
}
