/*
 * File:     MediaDescriptor.java
 * Project:  MPI Linguistic Application
 * Date:     12 December 2007
 *
 * Copyright (C) 2001-2008  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

package mpi.eudico.server.corpora.clomimpl.abstr;


/**
 * DOCUMENT ME!
 * $Id: MediaDescriptor.java 10960 2007-11-22 15:22:05Z hasloe $
 * @author $Author$
 * @version $Revision$
 */
public class MediaDescriptor implements Cloneable {
    /** Holds value of property DOCUMENT ME! */
    public final static String MPG_MIME_TYPE = "video/mpeg";

    /** Holds value of property DOCUMENT ME! */
    public final static String WAV_MIME_TYPE = "audio/x-wav";

    /** Holds value of constant unknown MIME type */
    public final static String UNKNOWN_MIME_TYPE = "unknown";

    /** a constant for QuickTime file types */
    public static final String QUICKTIME_MIME_TYPE = "video/quicktime";

    /** a constant for any video type */
    public static final String GENERIC_VIDEO_TYPE = "video/*";

    /** a constant for any audio type */
    public static final String GENERIC_AUDIO_TYPE = "audio/*";

    /** Holds value of property DOCUMENT ME! */
    public String mediaURL;

    /** holds the relative URL, relative to the containing document */
    public String relativeMediaURL;

    /** Holds value of property DOCUMENT ME! */
    public String mimeType;

    /** Holds value of property DOCUMENT ME! */
    public long timeOrigin;

    /** Holds value of property DOCUMENT ME! */
    public String extractedFrom;

    /** Holds value of property DOCUMENT ME! */
    public boolean isValid;

    /**
     * Creates a new MediaDescriptor instance
     *
     * @param theMediaURL DOCUMENT ME!
     * @param theMimeType DOCUMENT ME!
     */
    public MediaDescriptor(String theMediaURL, String theMimeType) {
        mediaURL = theMediaURL;

        if (theMimeType != null) {
            mimeType = theMimeType;
        } else {
            mimeType = UNKNOWN_MIME_TYPE;
        }

        isValid = true;
    }

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public String toString() {
        return mediaURL + " " + mimeType + " " + timeOrigin + " " +
        extractedFrom;
    }

    /**
     * Returns a deep copy of this MediaDescriptor.
     *
     * @return a deep copy of this MediaDescriptor
     */
    public Object clone() {
        try {
            MediaDescriptor cloneMD = (MediaDescriptor) super.clone();

            if (mediaURL != null) {
                cloneMD.mediaURL = new String(mediaURL);
            }

            if (relativeMediaURL != null) {
                cloneMD.relativeMediaURL = new String(relativeMediaURL);
            }

            if (mimeType != null) {
                cloneMD.mimeType = new String(mimeType);
            }

            if (extractedFrom != null) {
                cloneMD.extractedFrom = new String(extractedFrom);
            }

            cloneMD.timeOrigin = timeOrigin;
            cloneMD.isValid = isValid;

            return cloneMD;
        } catch (CloneNotSupportedException cnse) {
            // should not happen
            // throw an exception?
            return null;
        }
    }

    /**
     * Overrides <code>Object</code>'s equals method by checking all
     * fields of the other object to be equal to all fields in this
     * object.
     *
     * @param obj the reference object with which to compare
     * @return true if this object is the same as the obj argument; false otherwise
     */
    public boolean equals(Object obj) {
        if (obj == null) {
            // null is never equal
            return false;
        }

        if (obj == this) {
            // same object reference 
            return true;
        }

        if (!(obj instanceof MediaDescriptor)) {
            // it should be a MediaDescriptor object
            return false;
        }

        // check the fields
        MediaDescriptor other = (MediaDescriptor) obj;

        if (((this.mediaURL != null) && (other.mediaURL == null)) ||
                ((this.mediaURL == null) && (other.mediaURL != null)) ||
                ((this.mediaURL != null) && (other.mediaURL != null) &&
                !this.mediaURL.equals(other.mediaURL))) {
            return false;
        }

        if (((this.relativeMediaURL != null) &&
                (other.relativeMediaURL == null)) ||
                ((this.relativeMediaURL == null) &&
                (other.relativeMediaURL != null)) ||
                ((this.relativeMediaURL != null) &&
                (other.relativeMediaURL != null) &&
                !this.relativeMediaURL.equals(other.relativeMediaURL))) {
            return false;
        }

        if (((this.mimeType != null) && (other.mimeType == null)) ||
                ((this.mimeType == null) && (other.mimeType != null)) ||
                ((this.mimeType != null) && (other.mimeType != null) &&
                !this.mimeType.equals(other.mimeType))) {
            return false;
        }

        if (((this.extractedFrom != null) && (other.extractedFrom == null)) ||
                ((this.extractedFrom == null) && (other.extractedFrom != null)) ||
                ((this.extractedFrom != null) && (other.extractedFrom != null) &&
                !this.extractedFrom.equals(other.extractedFrom))) {
            return false;
        }

        if (this.timeOrigin != other.timeOrigin) {
            return false;
        }

        if (this.isValid != other.isValid) {
            return false;
        }

        return true;
    }
}
