/*
 * File:     ParserFactory.java
 * Project:  MPI Linguistic Application
 * Date:     12 December 2007
 *
 * Copyright (C) 2001-2008  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

/*
 * Created on Jun 4, 2004
 *
 * To change the template for this generated file go to
 * Window&gt;Preferences&gt;Java&gt;Code Generation&gt;Code and Comments
 */
package mpi.eudico.server.corpora.clomimpl.abstr;

import mpi.eudico.server.corpora.clomimpl.chat.CHATParser;

//import mpi.eudico.server.corpora.clomimpl.cgn2acm.CGN2ACMParser;
import mpi.eudico.server.corpora.clomimpl.delimitedtext.DelimitedTextParser;
import mpi.eudico.server.corpora.clomimpl.dobes.EAF21Parser;
import mpi.eudico.server.corpora.clomimpl.dobes.EAF22Parser;
import mpi.eudico.server.corpora.clomimpl.dobes.EAF23Parser;
import mpi.eudico.server.corpora.clomimpl.dobes.EAF24Parser;
import mpi.eudico.server.corpora.clomimpl.dobes.EAF25Parser;
import mpi.eudico.server.corpora.clomimpl.shoebox.ShoeboxParser;
import mpi.eudico.server.corpora.clomimpl.transcriber.Transcriber14Parser;


/**
 * @author hennie
 *
 * @version Dec 2006: constant for EAF24 added
 */
public class ParserFactory {
    /** Holds value of property DOCUMENT ME! */
    public static final int EAF21 = 0;

    /** Holds value of property DOCUMENT ME! */
    public static final int CHAT = 1;

    /** Holds value of property DOCUMENT ME! */
    public static final int SHOEBOX = 2;

    /** Holds value of property DOCUMENT ME! */
    public static final int TRANSCRIBER = 3;

    /** Holds value of property DOCUMENT ME! */
    public static final int CGN = 4;

    /** Holds value of property DOCUMENT ME! */
    public static final int WAC = 5;

    /** Holds value of property DOCUMENT ME! */
    public static final int EAF22 = 6;

    /** Holds value of property DOCUMENT ME! */
    public static final int EAF23 = 7;

    /** Holds value of property DOCUMENT ME! */
    public static final int EAF24 = 8;

    /** Holds value of property DOCUMENT ME! */
    public static final int EAF25 = 9;

    /** Holds value of property DOCUMENT ME! */
    public static final int CSV = 10;

    /**
     * DOCUMENT ME!
     *
     * @param parserCode DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public static Parser getParser(int parserCode) {
        switch (parserCode) {
        case EAF21:
            return new EAF21Parser();

        case EAF22:
            return new EAF22Parser();

        case EAF23:
            return new EAF23Parser();

        case EAF24:
            return new EAF24Parser();

        case EAF25:
            return new EAF25Parser();

        case CHAT:
            return new CHATParser();

        case SHOEBOX:
            return new ShoeboxParser();

        case TRANSCRIBER:
            return new Transcriber14Parser();

        case CGN: {
            //done this way to avoid explicit dependencies!
            Parser parser = null;

            try {
                parser = (Parser) Class.forName(
                        "mpi.eudico.server.corpora.clomimpl.cgn2acm.CGN2ACMParser")
                                       .newInstance();
            } catch (Exception e) {
                e.printStackTrace();
            }

            return parser;
        }

        case CSV:
            return new DelimitedTextParser();

        default:
            return null;
        }
    }
}
