/*
 * File:     TierUnsharedInfoImpl.java
 * Project:  MPI Linguistic Application
 * Date:     12 December 2007
 *
 * Copyright (C) 2001-2008  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

package mpi.eudico.server.corpora.clomimpl.abstr;

import mpi.eudico.server.corpora.clom.Tier;
import mpi.eudico.server.corpora.clom.TierUnsharedInfo;

import mpi.eudico.server.corpora.event.NotImplementedException;


/**
 * TierUnsharedInfoImpl consists of attributes that are unique the Tier's
 * Transcription.
 *
 * @author Hennie Brugman
 * @author Albert Russel
 * @version 6-May-1999
 * @version Aug 2005 Identity removed
 */
public class TierUnsharedInfoImpl implements TierUnsharedInfo {
    private Tier tier;

    /** Holds value of property DOCUMENT ME! */
    protected String transcriber;

    /** Holds value of property DOCUMENT ME! */
    protected String quality;

    /**
     * Creates a new TierUnsharedInfoImpl instance
     *
     * @param theTier DOCUMENT ME!
     */
    public TierUnsharedInfoImpl(Tier theTier) {
        tier = theTier;
    }

    /**
     * Gives the name of the person who has transcribed this Tier. This method
     * is implemented using a 'proxy' approach.
     *
     * @return the Transcriber's name
     *
     * @exception NotImplementedException is thrown when a specific
     *            implementation     class is not able to return a Transcriber
     */
    public String getTranscriber() throws NotImplementedException {
        return transcriber;
    }

    /**
     * Returns a string describing the exactness of time alignment of the
     * Tier's Tags. This method is implemented using a 'proxy' approach.
     *
     * @return the quality of the tier's Tag alignment
     *
     * @exception NotImplementedException thrown when a specific implementation
     *            class is not able to determine a quality
     */
    public String getQuality() throws NotImplementedException {
        return quality;
    }
}
