/*
 * File:     CHATEncoderInfo.java
 * Project:  MPI Linguistic Application
 * Date:     12 December 2007
 *
 * Copyright (C) 2001-2008  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

/*
 * Created on Jan 26, 2005
 */
package mpi.eudico.server.corpora.clomimpl.chat;

import mpi.eudico.server.corpora.clom.EncoderInfo;


/**
 * CHAT specific EncoderInfo implementation
 * may 06 (HS): added booleans for two export options:<br>
 * - whether or not to recalculate begin and end times of annotations based on the master media offset<br>
 * - if true the filename and begin and end time should be on a separate line (%snd or %mov) otherwise
 * or this info is appended to the main annotation value
 * @author hennie
 */
public class CHATEncoderInfo implements EncoderInfo {
    private boolean correctAnnotationTimes = true;
    private boolean timesOnSeparateLine = false;
    private long mediaOffset = 0L;
    private String[][] mainTierInfo;
    private String[][] dependentTierInfo;

    /**
     * Creates a new CHATEncoderInfo instance
     *
     * @param mainTierInfo DOCUMENT ME!
     * @param dependentTierInfo DOCUMENT ME!
     */
    public CHATEncoderInfo(String[][] mainTierInfo, String[][] dependentTierInfo) {
        this.mainTierInfo = mainTierInfo;
        this.dependentTierInfo = dependentTierInfo;
    }

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public String[][] getMainTierInfo() {
        return mainTierInfo;
    }

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public String[][] getDependentTierInfo() {
        return dependentTierInfo;
    }

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public boolean getCorrectAnnotationTimes() {
        return correctAnnotationTimes;
    }

    /**
     * DOCUMENT ME!
     *
     * @param correctAnnotationTimes DOCUMENT ME!
     */
    public void setCorrectAnnotationTimes(boolean correctAnnotationTimes) {
        this.correctAnnotationTimes = correctAnnotationTimes;
    }

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public boolean isTimesOnSeparateLine() {
        return timesOnSeparateLine;
    }

    /**
     * DOCUMENT ME!
     *
     * @param timesOnSeparateLine DOCUMENT ME!
     */
    public void setTimesOnSeparateLine(boolean timesOnSeparateLine) {
        this.timesOnSeparateLine = timesOnSeparateLine;
    }

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public long getMediaOffset() {
        return mediaOffset;
    }

    /**
     * DOCUMENT ME!
     *
     * @param mediaOffset DOCUMENT ME!
     */
    public void setMediaOffset(long mediaOffset) {
        this.mediaOffset = mediaOffset;
    }
}
