/*
 * File:     AnnotationRecord.java
 * Project:  MPI Linguistic Application
 * Date:     12 December 2007
 *
 * Copyright (C) 2001-2008  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

/*
 * Created on Jun 15, 2004
 *
 * To change the template for this generated file go to
 * Window&gt;Preferences&gt;Java&gt;Code Generation&gt;Code and Comments
 */
package mpi.eudico.server.corpora.clomimpl.dobes;


/**
 * @author hennie
 *
 * To change the template for this generated type comment go to
 * Window&gt;Preferences&gt;Java&gt;Code Generation&gt;Code and Comments
 */
public class AnnotationRecord {
    /** Holds value of property DOCUMENT ME! */
    public static final String ALIGNABLE = "alignable";

    /** Holds value of property DOCUMENT ME! */
    public static final String REFERENCE = "reference";

    /** Holds value of property DOCUMENT ME! */
    public static final String ALIGNABLE_SVG = "alignable_svg";
    private String annotId;
    private String annotType;
    private String beginTimeSlotId;
    private String endTimeSlotId;
    private String referredAnnotId;
    private String previousAnnotId;
    private String svgRefId;
    private String annotValue;
    private TimeSlotRecord beginTimeSlotRecord;
    private TimeSlotRecord endTimeSlotRecord;

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public String getAnnotationId() {
        return annotId;
    }

    /**
     * DOCUMENT ME!
     *
     * @param annotId DOCUMENT ME!
     */
    public void setAnnotationId(String annotId) {
        this.annotId = annotId;
    }

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public String getAnnotationType() {
        return annotType;
    }

    /**
     * DOCUMENT ME!
     *
     * @param annotType DOCUMENT ME!
     */
    public void setAnnotationType(String annotType) {
        this.annotType = annotType;
    }

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public String getBeginTimeSlotId() {
        if (beginTimeSlotRecord != null) {
            return "ts" + beginTimeSlotRecord.getId();
        }

        return beginTimeSlotId;
    }

    /**
     * DOCUMENT ME!
     *
     * @param beginTSId DOCUMENT ME!
     */
    public void setBeginTimeSlotId(String beginTSId) {
        beginTimeSlotId = beginTSId;
    }

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public String getEndTimeSlotId() {
        if (endTimeSlotRecord != null) {
            return "ts" + endTimeSlotRecord.getId();
        }

        return endTimeSlotId;
    }

    /**
     * DOCUMENT ME!
     *
     * @param endTSId DOCUMENT ME!
     */
    public void setEndTimeSlotId(String endTSId) {
        endTimeSlotId = endTSId;
    }

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public String getReferredAnnotId() {
        return referredAnnotId;
    }

    /**
     * DOCUMENT ME!
     *
     * @param refAnnotId DOCUMENT ME!
     */
    public void setReferredAnnotId(String refAnnotId) {
        referredAnnotId = refAnnotId;
    }

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public String getPreviousAnnotId() {
        return previousAnnotId;
    }

    /**
     * DOCUMENT ME!
     *
     * @param previousAnnotId DOCUMENT ME!
     */
    public void setPreviousAnnotId(String previousAnnotId) {
        this.previousAnnotId = previousAnnotId;
    }

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public String getSvgReference() {
        return svgRefId;
    }

    /**
     * DOCUMENT ME!
     *
     * @param svgRefId DOCUMENT ME!
     */
    public void setSvgReference(String svgRefId) {
        this.svgRefId = svgRefId;
    }

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public String getValue() {
        return annotValue;
    }

    /**
     * DOCUMENT ME!
     *
     * @param annotValue DOCUMENT ME!
     */
    public void setValue(String annotValue) {
        this.annotValue = annotValue;
    }

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public String toString() {
        String result = "";

        result += ("id:        " + annotId + "\n");
        result += ("type:      " + annotType + "\n");
        result += ("begin id:  " + beginTimeSlotId + "\n");
        result += ("end id:    " + endTimeSlotId + "\n");
        result += ("ref'ed id: " + referredAnnotId + "\n");
        result += ("prev id:   " + previousAnnotId + "\n");
        result += ("svg id:    " + svgRefId + "\n");
        result += ("value:     " + annotValue + "\n");

        return result;
    }

    /**
     * @return Returns the beginTimeSlotRecord.
     */
    public TimeSlotRecord getBeginTimeSlotRecord() {
        return beginTimeSlotRecord;
    }

    /**
     * @param beginTimeSlotRecord The beginTimeSlotRecord to set.
     */
    public void setBeginTimeSlotRecord(TimeSlotRecord beginTimeSlotRecord) {
        this.beginTimeSlotRecord = beginTimeSlotRecord;
    }

    /**
     * @return Returns the endTimeSlotRecord.
     */
    public TimeSlotRecord getEndTimeSlotRecord() {
        return endTimeSlotRecord;
    }

    /**
     * @param endTimeSlotRecord The endTimeSlotRecord to set.
     */
    public void setEndTimeSlotRecord(TimeSlotRecord endTimeSlotRecord) {
        this.endTimeSlotRecord = endTimeSlotRecord;
    }
}
