/*
 * File:     PraatTGEncoderInfo.java
 * Project:  MPI Linguistic Application
 * Date:     12 December 2007
 *
 * Copyright (C) 2001-2008  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

package mpi.eudico.server.corpora.clomimpl.praat;

import mpi.eudico.server.corpora.clom.EncoderInfo;


/**
 * An Encoder Info class for the Praat TextGrid Encoder. Stores the
 * selection/interval begin and end time.
 *
 * @author Han Sloetjes
 * @version 1.0
 */
public class PraatTGEncoderInfo implements EncoderInfo {
    /**
     * the 'xmin' value of the TextGrid file: the begin value of the selection
     * or 0
     */
    private long beginTime;

    /**
     * the 'xmax' value of the TextGrid file: the end of the selection or the
     * duration of the media file
     */
    private long endTime;

    /** the encoding for the Praat file */
    private String encoding;

    /**
     * Constructor.
     */
    public PraatTGEncoderInfo() {
        super();
    }

    /**
     * Constructor.
     *
     * @param bt the (selection) begin time
     * @param et the (selection) end time
     */
    public PraatTGEncoderInfo(long bt, long et) {
        super();
        beginTime = bt;
        endTime = et;
    }

    /**
     * Returns the (selection) begin time.
     *
     * @return Returns the begin time.
     */
    public long getBeginTime() {
        return beginTime;
    }

    /**
     * Sets the (selection) begin time.
     *
     * @param beginTime The begin time to set.
     */
    public void setBeginTime(long beginTime) {
        this.beginTime = beginTime;
    }

    /**
     * Returns the (selection) end time.
     *
     * @return Returns the end time.
     */
    public long getEndTime() {
        return endTime;
    }

    /**
     * Sets the (selection) end time.
     *
     * @param endTime The end time to set.
     */
    public void setEndTime(long endTime) {
        this.endTime = endTime;
    }

    /**
     * Returns the character encoding.
     *
     * @return the character encoding
     */
    public String getEncoding() {
        return encoding;
    }

    /**
     * Sets the character encoding
     *
     * @param encoding the character encoding
     */
    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }
}
