/*
 * File:     ToolboxDecoderInfo.java
 * Project:  MPI Linguistic Application
 * Date:     12 December 2007
 *
 * Copyright (C) 2001-2008  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

package mpi.eudico.server.corpora.clomimpl.shoebox;

import mpi.eudico.server.corpora.clom.DecoderInfo;

import java.util.List;


/**
 * A decoderinfo object for Toolbox/Shoebox files.
 */
public class ToolboxDecoderInfo implements DecoderInfo {
    private boolean timeInRefMarker;
    private boolean allUnicode;
    private long blockDuration;
    private String shoeboxFilePath;
    private String typeFile = "";
    private List shoeboxMarkers;

    /**
     * Creates a new ToolboxDecoderInfo object
     */
    public ToolboxDecoderInfo() {
    }

    /**
     * Creates a new ToolboxDecoderInfo object
     * @param shoeboxFilePath the path to the Toolbox/Shoebox file
     */
    public ToolboxDecoderInfo(String shoeboxFilePath) {
        this.shoeboxFilePath = shoeboxFilePath;
    }

    /**
     * Returns the block duration
     *
     * @return the block duration.
     */
    public long getBlockDuration() {
        return blockDuration;
    }

    /**
     * Sets the preferred/default block duration.
     *
     * @param blockDuration the blockDuration to set.
     */
    public void setBlockDuration(long blockDuration) {
        this.blockDuration = blockDuration;
    }

    /**
     * Returns the path to the Shoebox file.
     *
     * @return Returns the path to the Shoebox file
     */
    public String getSourceFilePath() {
        return shoeboxFilePath;
    }

    /**
     * Sets the path to the Shoebox/Toolbox file.
     *
     * @param shoeboxFilePath the path to the Shoebox/Toolbox file
     */
    public void setSourceFilePath(String shoeboxFilePath) {
        this.shoeboxFilePath = shoeboxFilePath;
    }

    /**
     * Returns whether or not the begintime of a marker unit/annotation should be extracted from
     * the record marker.
     *
     * @return the time in ref marker flag
     */
    public boolean isTimeInRefMarker() {
        return timeInRefMarker;
    }

    /**
     * Sets whether or not the begintime of a marker unit/annotation should be extracted from
     * the record marker.
     *
     * @param timeInRefMarker the new time in ref marker flag
     */
    public void setTimeInRefMarker(boolean timeInRefMarker) {
        this.timeInRefMarker = timeInRefMarker;
    }

    /**
     * Returns the Shoebox Markers.
     *
     * @return Returns the Shoebox Markers.
     */
    public List getShoeboxMarkers() {
        return shoeboxMarkers;
    }

    /**
     * Sets the ShoeboxMarkers.
     *
     * @param shoeboxMarkers The Shoebox Markers to set.
     */
    public void setShoeboxMarkers(List shoeboxMarkers) {
        this.shoeboxMarkers = shoeboxMarkers;
    }

    /**
     * Returns the path to the .typ file.
     *
     * @return Returns the .typ File.
     */
    public String getTypeFile() {
        return typeFile;
    }

    /**
     * Sets the path to the .typ file.
     *
     * @param typeFile The typeFile to set.
     */
    public void setTypeFile(String typeFile) {
        this.typeFile = typeFile;
    }

    /**
     * Returns whether all marker fields in the Toolbox file should be considered as Unicode,
     * instead of the default assumption of ISO Latin.
     * @return Returns the allUnicode value.
     */
    public boolean isAllUnicode() {
        return allUnicode;
    }

    /**
     * Sets whether all markers should be treated as Unicode markers.
     * @param allUnicode if true all fields should be parsed as Unicode fields
     */
    public void setAllUnicode(boolean allUnicode) {
        this.allUnicode = allUnicode;
    }
}
