/*
 * File:     TranscriberEvent.java
 * Project:  MPI Linguistic Application
 * Date:     12 December 2007
 *
 * Copyright (C) 2001-2008  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

/*
 * Created on Feb 4, 2005
 *
 */
package mpi.eudico.server.corpora.clomimpl.transcriber;


/**
 * Utility class to map Transcriber Events to Strings that can be embedded
 * in Annotations.
 *
 * @author hennie
 */
public class TranscriberEvent {
    /**
     * DOCUMENT ME!
     *
     * @param desc DOCUMENT ME!
     * @param extent DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public static String getEventString(String desc, String extent) {
        //String enclosedPart = desc;
        String prefix = "";
        String suffix = "";

        if (extent != null) {
            if (extent.equals("begin")) {
                desc += "-";
            } else if (extent.equals("end")) {
                desc = "-" + desc;
            } else if (extent.equals("previous")) {
                prefix = "+";
            } else if (extent.equals("next")) {
                suffix = "+";
            }
        }

        return prefix + " [" + desc + "] " + suffix;
    }
}
