/*
 * File:     MultipleRefs.java
 * Project:  MPI Linguistic Application
 * Date:     12 December 2007
 *
 * Copyright (C) 2001-2008  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

package mpi.eudico.server.corpora.clomimpl.type;

import mpi.eudico.server.corpora.clom.Annotation;

import mpi.eudico.server.corpora.clomimpl.abstr.RefAnnotation;

import java.util.Iterator;


/**
 * DOCUMENT ME!
 * $Id: MultipleRefs.java 2 2004-03-25 16:22:33Z wouthuij $
 * @author $Author$
 * @version $Revision$
 */
public class MultipleRefs extends ConstraintImpl {
    /**
     * Creates a new MultipleRefs instance
     */
    public MultipleRefs() {
        super();
    }

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public int getStereoType() {
        return Constraint.MULTIPLE_REFS;
    }

    /**
     * DOCUMENT ME!
     *
     * @param theAnnot DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public long getBeginTimeForRefAnnotation(RefAnnotation theAnnot) {
        long beginTimeBoundary = Long.MAX_VALUE;
        long beginB = 0;

        Iterator refIter = theAnnot.getReferences().iterator();

        while (refIter.hasNext()) {
            beginB = ((Annotation) refIter.next()).getBeginTimeBoundary();

            beginTimeBoundary = Math.min(beginTimeBoundary, beginB);
        }

        return beginTimeBoundary;
    }

    /**
     * DOCUMENT ME!
     *
     * @param theAnnot DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public long getEndTimeForRefAnnotation(RefAnnotation theAnnot) {
        long endTimeBoundary = 0;
        long endB = 0;

        Iterator refIter = theAnnot.getReferences().iterator();

        while (refIter.hasNext()) {
            endB = ((Annotation) refIter.next()).getEndTimeBoundary();

            endTimeBoundary = Math.max(endTimeBoundary, endB);
        }

        return endTimeBoundary;
    }
}
