/*
 * File:     ACMEditEvent.java
 * Project:  MPI Linguistic Application
 * Date:     12 December 2007
 *
 * Copyright (C) 2001-2008  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

package mpi.eudico.server.corpora.event;

import java.util.EventObject;


/**
 * DOCUMENT ME!
 * $Id: ACMEditEvent.java 10390 2007-09-28 14:36:42Z klasal $
 * @author $Author$
 * @version $Revision$
 */
public class ACMEditEvent extends EventObject {
    // operation constants

    /** Holds value of property DOCUMENT ME! */
    public static final int ADD_TIER = 0;

    /** Holds value of property DOCUMENT ME! */
    public static final int REMOVE_TIER = 1;

    /** Holds value of property DOCUMENT ME! */
    public static final int CHANGE_TIER = 2;

    /** Holds value of property DOCUMENT ME! */
    public static final int ADD_ANNOTATION_HERE = 3;

    /** Holds value of property DOCUMENT ME! */
    public static final int ADD_ANNOTATION_BEFORE = 4;

    /** Holds value of property DOCUMENT ME! */
    public static final int ADD_ANNOTATION_AFTER = 5;

    /** Holds value of property DOCUMENT ME! */
    public static final int REMOVE_ANNOTATION = 6;

    /** Holds value of property DOCUMENT ME! */
    public static final int CHANGE_ANNOTATION_TIME = 7;

    /** Holds value of property DOCUMENT ME! */
    public static final int CHANGE_ANNOTATION_VALUE = 8;

    /** Holds value of property DOCUMENT ME! */
    public static final int ADD_LINGUISTIC_TYPE = 9;

    /** Holds value of property DOCUMENT ME! */
    public static final int REMOVE_LINGUISTIC_TYPE = 10;

    /** Holds value of property DOCUMENT ME! */
    public static final int CHANGE_LINGUISTIC_TYPE = 11;

    /** Holds value of property DOCUMENT ME! */
    public static final int CHANGE_ANNOTATION_GRAPHICS = 12;

    /** marks any change in a ControlledVocabulary */
    public static final int CHANGE_CONTROLLED_VOCABULARY = 13;

    /** any changes in an unspecified number of annotations
     *  on an unspecified number of tiers */
    public static final int CHANGE_ANNOTATIONS = 14;

    // members
    private int operation;
    private Object modification;

    // constructor
    public ACMEditEvent(Object invalidatedObject, int theOperation,
        Object theModification) {
        super(invalidatedObject);

        operation = theOperation;
        modification = theModification;
    }

    // methods

    /**
     * Returns the Object that is invalidated by the ACM edit operation.
     *
     * @return DOCUMENT ME!
     */
    public Object getInvalidatedObject() {
        return getSource();
    }

    /**
     * Return an integer constant indicating the nature of the ACM edit
     * operation. These constants are defined by this class itself.
     *
     * @return DOCUMENT ME!
     */
    public int getOperation() {
        return operation;
    }

    /**
     * Returns the object that modifies the invalidated Object. Example: in
     * case of adding an annotation to a tier, the tier is invalidated, and
     * the modification is the added annotation.
     *
     * @return DOCUMENT ME!
     */
    public Object getModification() {
        return modification;
    }
}
