/*
 * File:     Constraint.java
 * Project:  MPI Linguistic Application
 * Date:     12 December 2007
 *
 * Copyright (C) 2001-2008  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

package mpi.search.content.query.model;

import java.util.HashMap;

import javax.swing.tree.MutableTreeNode;


/**
 * Created on Aug 18, 2004
 *
 * @author Alexander Klassmann
 * @version Aug 18, 2004
 */
public interface Constraint extends MutableTreeNode, Cloneable {
    /** Holds value of property DOCUMENT ME! */
    public static final String ALL_TIERS = "Search.Constraint.AllTiers";

    /**
     *
     */
    public static final String TEMPORAL = "Search.Constraint.Temporal";

    /**
     *
     */
    public static final String STRUCTURAL = "Search.Constraint.Structural";

    /**
     *
     */
    public static final String[] MODES = { STRUCTURAL, TEMPORAL };

    /**
     *
     */
    public static final String ANY = "Search.Constraint.Any";

    /**
     *
     */
    public static final String NONE = "Search.Constraint.None";

    /**
     *
     */
    public static final String[] QUANTIFIERS = new String[] { ANY, NONE };

    /**
     *
     */
    public static final String IS_INSIDE = "Search.Constraint.Inside";

    /**
     *
     */
    public static final String OVERLAP = "Search.Constraint.Overlap";

    /**
     *
     */
    public static final String NOT_INSIDE = "Search.Constraint.NotInside";

    /**
     *
     */
    public static final String NO_OVERLAP = "Search.Constraint.NoOverlap";

    /**
     *
     */
    public static final String LEFT_OVERLAP = "Search.Constraint.LeftOverlap";

    /**
     *
     */
    public static final String RIGHT_OVERLAP = "Search.Constraint.RightOverlap";

    /**
     *
     */
    public static final String WITHIN_OVERALL_DISTANCE = "Search.Constraint.WithinOverallDistance";

    /**
     *
     */
    public static final String WITHIN_DISTANCE_TO_LEFT_BOUNDARY = "Search.Constraint.WithinLeftDistance";

    /**
     *
     */
    public static final String WITHIN_DISTANCE_TO_RIGHT_BOUNDARY = "Search.Constraint.WithinRightDistance";

    /**
     *
     */
    public static final String BEFORE_LEFT_DISTANCE = "Search.Constraint.BeforeLeftDistance";

    /**
     *
     */
    public static final String AFTER_RIGHT_DISTANCE = "Search.Constraint.AfterRightDistance";

    /**
     *
     */
    public static final String[] ANCHOR_CONSTRAINT_TIME_RELATIONS = {
        IS_INSIDE, OVERLAP, NOT_INSIDE, NO_OVERLAP
    };

    /**
     *
     */
    public static final String[] DEPENDENT_CONSTRAINT_TIME_RELATIONS = {
        IS_INSIDE, OVERLAP, LEFT_OVERLAP, RIGHT_OVERLAP, WITHIN_OVERALL_DISTANCE,
        WITHIN_DISTANCE_TO_LEFT_BOUNDARY, WITHIN_DISTANCE_TO_RIGHT_BOUNDARY,
        BEFORE_LEFT_DISTANCE, AFTER_RIGHT_DISTANCE
    };

    /** Holds value of property DOCUMENT ME! */
    public static final String regExMetaChars = "\\.^$*+?{}[]()|";

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public HashMap getAttributes();

    /**
     *
     *
     * @param b DOCUMENT ME!
     */
    public void setCaseSensitive(boolean b);

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public boolean isCaseSensitive();

    /**
     *
     *
     * @param l DOCUMENT ME!
     */
    public void setLowerBoundary(long l);

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public long getLowerBoundary();

    /**
     *
     *
     * @return DOCUMENT ME!
     */
    public String getLowerBoundaryAsString();

    /**
     *
     *
     * @return DOCUMENT ME!
     */
    public String getMode();

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public String getId();

    /**
     *
     *
     * @param s DOCUMENT ME!
     */
    public void setPattern(String s);

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public String getPattern();

    /**
     * returns Quantifier like ("ANY" or "NONE")
     *
     * @return String
     */
    public String getQuantifier();

    /**
     *
     *
     * @param b DOCUMENT ME!
     */
    public void setRegEx(boolean b);

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public boolean isRegEx();

    /**
     *
     *
     * @param s DOCUMENT ME!
     */
    public void setTierNames(String[] s);

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public String getTierName();

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public String[] getTierNames();

    /**
     *
     *
     * @param s DOCUMENT ME!
     */
    public void setUnit(String s);

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public String getUnit();

    /**
     *
     *
     * @param l DOCUMENT ME!
     */
    public void setUpperBoundary(long l);

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public long getUpperBoundary();

    /**
     *
     *
     * @return DOCUMENT ME!
     */
    public String getUpperBoundaryAsString();

    /**
     * DOCUMENT ME!
     *
     * @param h DOCUMENT ME!
     */
    public void setAttributes(HashMap h);

    /**
     * DOCUMENT ME!
     *
     * @param name DOCUMENT ME!
     * @param value DOCUMENT ME!
     */
    public void addAttribute(String name, String value);

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public Object clone();

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public boolean isEditable();
}
