/*
 * File:     ContentQuery.java
 * Project:  MPI Linguistic Application
 * Date:     12 December 2007
 *
 * Copyright (C) 2001-2008  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

package mpi.search.content.query.model;

import mpi.search.content.model.CorpusType;

import mpi.search.content.result.model.ContentResult;

import mpi.search.query.model.Query;

import mpi.search.result.model.Result;

import java.io.File;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;

import javax.swing.tree.TreeNode;


/**
 * $Id: ContentQuery.java 8348 2007-03-09 09:43:13Z klasal $
 *
 * @author $Author$
 * @version $Revision$
 */
public class ContentQuery extends Query {
    /** Holds value of property DOCUMENT ME! */
    private final ContentResult result = new ContentResult();
    private AnchorConstraint anchorConstraint;

    /** Holds value of property DOCUMENT ME! */
    private final CorpusType type;

    /** Holds value of property DOCUMENT ME! */
    private final File[] files;

    /**
     * Creates a new ContentQuery object.
     *
     * @param rootConstraint DOCUMENT ME!
     * @param type DOCUMENT ME!
     */
    public ContentQuery(AnchorConstraint rootConstraint, CorpusType type) {
        this(rootConstraint, type, null);
    }

    /**
     * Creates a new Query instance
     *
     * @param rootConstraint DOCUMENT ME!
     * @param type DOCUMENT ME!
     * @param files DOCUMENT ME!
     */
    public ContentQuery(AnchorConstraint rootConstraint, CorpusType type,
        File[] files) {
        this.anchorConstraint = rootConstraint;
        this.type = type;
        this.files = files;
    }

    /**
     *
     *
     * @param rootConstraint DOCUMENT ME!
     */
    public final void setAnchorConstraint(AnchorConstraint rootConstraint) {
        this.anchorConstraint = rootConstraint;
    }

    /**
     *
     *
     * @return DOCUMENT ME!
     */
    public final AnchorConstraint getAnchorConstraint() {
        return anchorConstraint;
    }

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public final List getConstraints() {
        List constraintList = new ArrayList();
        addChildren(constraintList, anchorConstraint);

        return constraintList;
    }

    /**
     *
     *
     * @return DOCUMENT ME!
     */
    public File[] getFiles() {
        return files;
    }

    /**
     *
     *
     * @return DOCUMENT ME!
     */
    public final boolean isRestricted() {
        return anchorConstraint instanceof RestrictedAnchorConstraint;
    }

    /**
     *
     *
     * @return DOCUMENT ME!
     */
    public Result getResult() {
        return result;
    }

    /**
     *
     *
     * @return DOCUMENT ME!
     */
    public final CorpusType getType() {
        return type;
    }

    /**
     * Returns false, if there is one constraint with an empty search
     * expression
     *
     * @return boolean
     */
    public final boolean isWellSpecified() {
        boolean wellSpecified = true;

        List constraintList = getConstraints();

        for (int i = 0; i < constraintList.size(); i++) {
            if (constraintList.get(i) != null) {
                if (((Constraint) constraintList.get(i)).isRegEx() &&
                        ((Constraint) constraintList.get(i)).getPattern()
                             .equals("")) {
                    wellSpecified = false;
                }
            }
        }

        return wellSpecified;
    }

    /**
     *
     *
     * @param object DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public boolean equals(Object object) {
        if (!(object instanceof ContentQuery)) {
            return false;
        }

        return getConstraints().equals(((ContentQuery) object).getConstraints());
    }

    /**
     * Translates query to human readable text. (Debugging)
     *
     * @return DOCUMENT ME!
     */
    public String toString() {
        StringBuffer sb = new StringBuffer();
        List constraintList = getConstraints();

        for (int i = 0; i < constraintList.size(); i++) {
            sb.append(constraintList.get(i).toString());
        }

        return sb.toString();
    }

    /**
     * DOCUMENT ME!
     *
     * @param list DOCUMENT ME!
     * @param node DOCUMENT ME!
     */
    private final void addChildren(List list, TreeNode node) {
        list.add(node);

        for (Enumeration e = node.children(); e.hasMoreElements();) {
            addChildren(list, (TreeNode) e.nextElement());
        }
    }
}
