/*
 * File:     AbstractDistancePanel.java
 * Project:  MPI Linguistic Application
 * Date:     12 December 2007
 *
 * Copyright (C) 2001-2008  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

package mpi.search.content.query.viewer;

import mpi.search.SearchLocale;

import java.awt.FlowLayout;

import javax.swing.JPanel;


/**
 * Created on May 26, 2004
 *
 * @author Alexander Klassmann
 * @version May 26, 2004
 */
public abstract class AbstractDistancePanel extends JPanel {
    /**
     * Creates a new AbstractDistancePanel instance
     */
    AbstractDistancePanel() {
        setLayout(new FlowLayout(FlowLayout.LEFT, 0, 0));
    }

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    abstract public String getUnit();

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    abstract public long getLowerBoundary();

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    abstract public long getUpperBoundary();

    /**
     * DOCUMENT ME!
     *
     * @param s DOCUMENT ME!
     */
    abstract public void setUnit(String s);

    /**
     * DOCUMENT ME!
     *
     * @param lowerBoundary DOCUMENT ME!
     */
    abstract public void setLowerBoundary(long lowerBoundary);

    /**
     * DOCUMENT ME!
     *
     * @param upperBoundary DOCUMENT ME!
     */
    abstract public void setUpperBoundary(long upperBoundary);

    /**
     * DOCUMENT ME!
     *
     * @param s DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    protected long getLong(String s) {
        long l = 0;

        if (s.toUpperCase().equals("-X")) {
            l = Long.MIN_VALUE;
        } else if (s.toUpperCase().equals("X") || s.toUpperCase().equals("X")) {
            l = Long.MAX_VALUE;
        }

        try {
            l = Long.parseLong(s);
        } catch (NumberFormatException e) {
            System.out.println(SearchLocale.getString(
                    "Search.Exception.WrongNumberFormat") + ": " +
                e.getMessage());
        }

        return l;
    }

    /**
     * DOCUMENT ME!
     *
     * @param l DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    protected String getString(long l) {
        return ((l != Long.MIN_VALUE) && (l != Long.MAX_VALUE)) ? ("" + l) : "";
    }
}
