/*
 * File:     AnchorTemporalDistancePanel.java
 * Project:  MPI Linguistic Application
 * Date:     12 December 2007
 *
 * Copyright (C) 2001-2008  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

package mpi.search.content.query.viewer;

import mpi.search.SearchLocale;

import mpi.search.content.query.model.*;

import java.awt.Font;

import javax.swing.JComboBox;
import javax.swing.JLabel;


/**
 * $Id: AnchorTemporalDistancePanel.java 8007 2007-01-30 16:20:17Z klasal $
 *
 * $Author$
 *
 */
public class AnchorTemporalDistancePanel extends TemporalDistancePanel {
    /**
     * Creates a new AnchorTemporalDistancePanel object.
     */
    public AnchorTemporalDistancePanel() {
        timeRelationComboBox = new JComboBox(AnchorConstraint.ANCHOR_CONSTRAINT_TIME_RELATIONS);
        timeRelationComboBox.setRenderer(new LocalizeListCellRenderer());

        JLabel label = new JLabel(SearchLocale.getString("Search.And") + " ");
        label.setFont(getFont().deriveFont(Font.PLAIN));
        add(label);
        add(timeRelationComboBox);
        label = new JLabel(" " + SearchLocale.getString("Search.Interval") +
                " ");
        label.setFont(getFont().deriveFont(Font.PLAIN));
        add(label);

        JLabel open = new JLabel("[");
        open.setFont(getFont().deriveFont(20f));
        open.setVerticalAlignment(JLabel.TOP);
        add(open);
        add(fromTimeField);
        add(new JLabel(" ; "));
        add(toTimeField);

        JLabel close = new JLabel("]");
        close.setFont(getFont().deriveFont(20f));
        close.setVerticalAlignment(JLabel.TOP);
        add(close);
        timeRelationComboBox.setSelectedIndex(0);
    }
}
