/*
 * File:     ConstraintEditor.java
 * Project:  MPI Linguistic Application
 * Date:     12 December 2007
 *
 * Copyright (C) 2001-2008  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

package mpi.search.content.query.viewer;

import mpi.search.content.model.CorpusType;

import mpi.search.content.query.model.AnchorConstraint;
import mpi.search.content.query.model.DependentConstraint;

import java.awt.Component;

import javax.swing.AbstractCellEditor;
import javax.swing.Action;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellEditor;


/**
 * $Id: ConstraintEditor.java 7367 2006-11-28 14:23:51Z klasal $
 *
 * @author $author$
 * @version $Revision$
 */
public class ConstraintEditor extends AbstractCellEditor
    implements TreeCellEditor {
    private AbstractConstraintPanel constraintPanel;

    /** Holds value of property DOCUMENT ME! */
    private final Action startAction;

    /** Holds value of property DOCUMENT ME! */
    private final CorpusType type;

    /** Holds value of property DOCUMENT ME! */
    private final DefaultTreeModel treeModel;

    /**
     * Creates a new ConstraintEditor object.
     *
     * @param treeModel DOCUMENT ME!
     * @param type DOCUMENT ME!
     * @param startAction DOCUMENT ME!
     */
    public ConstraintEditor(DefaultTreeModel treeModel, CorpusType type,
        Action startAction) {
        this.treeModel = treeModel;
        this.type = type;
        this.startAction = startAction;
    }

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public Object getCellEditorValue() {
        return constraintPanel.getConstraint();
    }

    /**
     * DOCUMENT ME!
     *
     * @param tree DOCUMENT ME!
     * @param value DOCUMENT ME!
     * @param selected DOCUMENT ME!
     * @param expanded DOCUMENT ME!
     * @param leaf DOCUMENT ME!
     * @param row DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public Component getTreeCellEditorComponent(JTree tree, Object value,
        boolean selected, boolean expanded, boolean leaf, int row) {
        if (value instanceof AnchorConstraint) {
            constraintPanel = new AnchorConstraintPanel((AnchorConstraint) value,
                    treeModel, type, startAction);
        } else if (value instanceof DependentConstraint) {
            constraintPanel = new DependentConstraintPanel((DependentConstraint) value,
                    treeModel, type, startAction);
        }

        return constraintPanel;
    }
}
