/*
 * File:     DependentConstraintPanel.java
 * Project:  MPI Linguistic Application
 * Date:     12 December 2007
 *
 * Copyright (C) 2001-2008  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

package mpi.search.content.query.viewer;

import mpi.search.SearchLocale;

import mpi.search.content.model.CorpusType;

import mpi.search.content.query.model.Constraint;
import mpi.search.content.query.model.DependentConstraint;

import java.awt.Dimension;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;

import javax.swing.Action;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.tree.DefaultTreeModel;


/**
 * Created on Aug 18, 2004
 *
 * @author Alexander Klassmann
 * @version Aug 18, 2004
 */
public class DependentConstraintPanel extends AbstractConstraintPanel {
    /** Holds value of property DOCUMENT ME! */
    protected final JComboBox modeComboBox = new JComboBox(Constraint.MODES);

    /**
     * Creates a new DependentConstraintPanel object.
     *
     * @param constraint DOCUMENT ME!
     * @param treeModel DOCUMENT ME!
     * @param type DOCUMENT ME!
     * @param startAction DOCUMENT ME!
     */
    public DependentConstraintPanel(DependentConstraint constraint,
        DefaultTreeModel treeModel, CorpusType type, Action startAction) {
        super(constraint, treeModel, type, startAction);

        titleComponent.add(new JLabel(SearchLocale.getString(
                    "Search.Query.With").toUpperCase()));

        if (type.allowsTemporalConstraints()) {
            titleComponent.add(modeComboBox);
        }

        titleComponent.add(new JLabel(SearchLocale.getString(
                    "Search.Query.Constraint")));
        modeComboBox.setRenderer(new LocalizeListCellRenderer());
        modeComboBox.addItemListener(new ItemListener() {
                public void itemStateChanged(ItemEvent e) {
                    if (e.getStateChange() == ItemEvent.SELECTED) {
                        updateMode();
                    }
                }
            });
        tierComboBox = new JComboBox() {
                    public Dimension getPreferredSize() {
                        return new Dimension(tierComboBoxWidth,
                            super.getPreferredSize().height);
                    }
                };

        makeLayout();
        setConstraint(constraint);
        updateMode();
    }

    /**
     * DOCUMENT ME!
     *
     * @param c DOCUMENT ME!
     */
    public void setConstraint(DependentConstraint c) {
        try {
            setMode(c.getMode());
            patternPanel.setQuantifier(c.getQuantifier());
            setTierName(c.getTierName());
            super.setConstraint(c);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    //implementation of ItemListener
    public void itemStateChanged(ItemEvent e) {
        if (e.getStateChange() == ItemEvent.SELECTED) {
            if (e.getSource() == tierComboBox) {
                updateUnitComboBox();
            }
        }

        super.itemStateChanged(e);
    }

    /**
     * DOCUMENT ME!
     *
     * @param mode DOCUMENT ME!
     */
    protected void setMode(String mode) {
        modeComboBox.setSelectedItem(mode);

        //just to be sure; if item didn't change in combobox, nevertheless update!
        updateMode();
    }

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    protected String getMode() {
        return (String) modeComboBox.getSelectedItem();
    }

    /**
     * DOCUMENT ME!
     */
    protected void update() {
        if (Constraint.ALL_TIERS.equals(getTierNamesOfParent()[0]) ||
                (getTierNamesOfParent().length > 1)) {
            modeComboBox.setSelectedItem(Constraint.TEMPORAL);
            modeComboBox.setEnabled(false);
        } else {
            modeComboBox.setEnabled(true);
        }

        updateTierComboBox();
    }

    /**
     * DOCUMENT ME!
     */
    protected void updateMode() {
        update();
        relationPanel.setDistanceMode((String) modeComboBox.getSelectedItem());
    }

    /**
     * DOCUMENT ME!
     */
    protected void updateNode() {
        super.updateNode();
        ((DependentConstraint) constraint).setMode(getMode());
        ((DependentConstraint) constraint).setQuantifier(patternPanel.getQuantifier());
    }

    /**
     * DOCUMENT ME!
     */
    protected void updateTierComboBox() {
        if (Constraint.TEMPORAL.equals(getMode())) {
            updateComboBox(tierComboBox, type.getTierNames());
        } else {
            updateComboBox(tierComboBox,
                type.getRelatedTiers(getTierNamesOfParent()[0]));
            updateUnitComboBox();
        }
    }

    /**
     * Fills the unitComboBox with all SearchUnits which share the tier on this
     * constraint and the tier of the constraint it refers to
     */
    protected void updateUnitComboBox() {
        if (Constraint.STRUCTURAL.equals(getMode())) {
            String[] possibleUnits = (type.getPossibleUnitsFor((String) tierComboBox.getSelectedItem(),
                    getTierNamesOfParent()[0]));
            updateComboBox(relationPanel.getUnitComboBox(), possibleUnits);
        }
    }

    private String[] getTierNamesOfParent() {
        return ((Constraint) constraint.getParent()).getTierNames();
    }
}
