/*
 * File:     RelationPanel.java
 * Project:  MPI Linguistic Application
 * Date:     12 December 2007
 *
 * Copyright (C) 2001-2008  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

package mpi.search.content.query.viewer;

import mpi.search.content.model.CorpusType;

import mpi.search.content.query.model.AnchorConstraint;
import mpi.search.content.query.model.Constraint;

import java.awt.CardLayout;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;

import javax.swing.JComboBox;
import javax.swing.JPanel;


/**
 * Created on Jul 14, 2004
 * $Id: RelationPanel.java 7324 2006-11-23 16:06:42Z klasal $
 * $Author$
 * $Version$
 */
public class RelationPanel extends JPanel {
    /** Holds value of property DOCUMENT ME! */
    protected AbstractDistancePanel structuralDistancePanel;

    /** Holds value of property DOCUMENT ME! */
    protected AbstractDistancePanel temporalDistancePanel;

    /** Holds value of property DOCUMENT ME */
    protected final JComboBox quantifierComboBox = new JComboBox(Constraint.QUANTIFIERS);

    /** Holds value of property DOCUMENT ME! */
    private final CardLayout distanceInputLayout = new CardLayout();

    /** Holds value of property DOCUMENT ME! */
    private final JPanel distancePanelPlaceHolder = new JPanel(distanceInputLayout);

    /**
     * Creates a new RelationPanel instance
     *
     * @param type DOCUMENT ME!
     * @param constraint DOCUMENT ME!
     */
    protected RelationPanel(CorpusType type, Constraint constraint) {
        setLayout(new FlowLayout(FlowLayout.LEFT, 0, 0));

        GridBagConstraints c = new GridBagConstraints();

        if (constraint instanceof AnchorConstraint) {
            temporalDistancePanel = new AnchorTemporalDistancePanel();
        } else {
            temporalDistancePanel = new DependentTemporalDistancePanel();
        }

        structuralDistancePanel = new StructuralDistancePanel();
        distancePanelPlaceHolder.add(structuralDistancePanel,
            Constraint.STRUCTURAL);
        distancePanelPlaceHolder.add(temporalDistancePanel, Constraint.TEMPORAL);

        c.gridwidth = 1;
        c.gridy = 1;
        c.gridx = GridBagConstraints.RELATIVE;
        c.fill = GridBagConstraints.NONE;

        add(distancePanelPlaceHolder);

        c.anchor = GridBagConstraints.WEST;

        if (constraint instanceof AnchorConstraint &&
                !type.allowsTemporalConstraints()) {
            setVisible(false);
        } else {
            setDistanceMode(constraint.getMode());
        }
    }

    /**
     *
     *
     * @param mode DOCUMENT ME!
     */
    public void setDistanceMode(String mode) {
        distanceInputLayout.show(distancePanelPlaceHolder, mode);
    }

    /**
     * DOCUMENT ME!
     *
     * @param boundary DOCUMENT ME!
     */
    public void setLowerBoundary(long boundary) {
        (temporalDistancePanel.isVisible() ? temporalDistancePanel
                                           : structuralDistancePanel).setLowerBoundary(boundary);
    }

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public long getLowerBoundary() {
        return ((!isVisible() || temporalDistancePanel.isVisible())
        ? temporalDistancePanel : structuralDistancePanel).getLowerBoundary();
    }

    /**
     *
     *
     * @param unit DOCUMENT ME!
     */
    public void setUnit(String unit) {
        if (unit != null) {
            (temporalDistancePanel.isVisible() ? temporalDistancePanel
                                               : structuralDistancePanel).setUnit(unit);
        }
    }

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public String getUnit() {
        return (temporalDistancePanel.isVisible() ? temporalDistancePanel
                                                  : structuralDistancePanel).getUnit();
    }

    /**
     * Fills the unitComboBox with all SearchUnits which share the tier on this
     * constraint and the tier of the constraint it refers to
     *
     * @return DOCUMENT ME!
     */
    public JComboBox getUnitComboBox() {
        return ((StructuralDistancePanel) structuralDistancePanel).getUnitComboBox();
    }

    /**
     * DOCUMENT ME!
     *
     * @param boundary DOCUMENT ME!
     */
    public void setUpperBoundary(long boundary) {
        (temporalDistancePanel.isVisible() ? temporalDistancePanel
                                           : structuralDistancePanel).setUpperBoundary(boundary);
    }

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public long getUpperBoundary() {
        return ((!isVisible() || temporalDistancePanel.isVisible())
        ? temporalDistancePanel : structuralDistancePanel).getUpperBoundary();
    }
}
