/*
 * File:     TemporalDistancePanel.java
 * Project:  MPI Linguistic Application
 * Date:     12 December 2007
 *
 * Copyright (C) 2001-2008  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

package mpi.search.content.query.viewer;

import java.awt.*;

import javax.swing.JComboBox;


/**
 * Created on May 19, 2004
 *
 * @author Alexander Klassmann
 * @version May 19, 2004
 */
public class TemporalDistancePanel extends AbstractDistancePanel {
    /** Holds value of property DOCUMENT ME! */
    protected JComboBox timeRelationComboBox;

    /** Holds value of property DOCUMENT ME! */
    final protected TimeField fromTimeField = new TimeField(false);

    /** Holds value of property DOCUMENT ME! */
    final protected TimeField toTimeField = new TimeField(true);

    /**
     * Creates a new TemporalDistancePanel instance
     */
    public TemporalDistancePanel() {
        setLayout(new GridBagLayout());
    }

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public long getLowerBoundary() {
        return fromTimeField.getTime();
    }

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public long getUpperBoundary() {
        return toTimeField.getTime();
    }

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public String getUnit() {
        return (timeRelationComboBox.getSelectedIndex() != -1)
        ? (String) timeRelationComboBox.getSelectedItem() : "";
    }

    /**
     * DOCUMENT ME!
     *
     * @param milliSeconds DOCUMENT ME!
     */
    public void setLowerBoundary(long milliSeconds) {
        fromTimeField.setTime(milliSeconds);
    }

    /**
     * DOCUMENT ME!
     *
     * @param milliSeconds DOCUMENT ME!
     */
    public void setUpperBoundary(long milliSeconds) {
        toTimeField.setTime(milliSeconds);
    }

    /**
     * DOCUMENT ME!
     *
     * @param unit DOCUMENT ME!
     */
    public void setUnit(String unit) {
        timeRelationComboBox.setSelectedItem(unit);
    }
}
