/*
 * File:     AbstractContentMatch.java
 * Project:  MPI Linguistic Application
 * Date:     12 December 2007
 *
 * Copyright (C) 2001-2008  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

package mpi.search.content.result.model;


/**
 * DOCUMENT ME!
 *
 * @author klasal TODO To change the template for this generated type comment
 *         go to Window - Preferences - Java - Code Style - Code Templates
 */
public abstract class AbstractContentMatch implements ContentMatch {
    /** Holds value of property DOCUMENT ME! */
    protected String fileName = "";

    /** Holds value of property DOCUMENT ME! */
    protected String leftContext = "";

    /** Holds value of property DOCUMENT ME! */
    protected String rightContext = "";

    /** Holds value of property DOCUMENT ME! */
    protected String tierName = "";

    /** Holds value of property DOCUMENT ME! */
    protected int[][] matchedSubstringIndices;

    /** Holds value of property DOCUMENT ME! */
    protected int indexWithinTier = -1;

    /** Holds value of property DOCUMENT ME! */
    protected long beginTime;

    /** Holds value of property DOCUMENT ME! */
    protected long endTime;

    /* (non-Javadoc)
     * @see mpi.eudico.server.corpora.clom.AnnotationCore#getBeginTimeBoundary()
     */
    public long getBeginTimeBoundary() {
        return beginTime;
    }

    /* (non-Javadoc)
     * @see mpi.eudico.server.corpora.clom.AnnotationCore#getEndTimeBoundary()
     */
    public long getEndTimeBoundary() {
        return endTime;
    }

    /* (non-Javadoc)
     * @see mpi.eudico.search.advanced.result.model.Match#getFileName()
     */
    public String getFileName() {
        return fileName;
    }

    /**
     *
     *
     * @param i DOCUMENT ME!
     */
    public void setIndex(int i) {
        indexWithinTier = i;
    }

    /* (non-Javadoc)
     * @see mpi.eudico.search.advanced.result.model.Match#getIndex()
     */
    public int getIndex() {
        return indexWithinTier;
    }

    /* (non-Javadoc)
     * @see mpi.eudico.search.advanced.result.model.Match#getLeftContext()
     */
    public String getLeftContext() {
        return leftContext;
    }

    /* (non-Javadoc)
     * @see mpi.eudico.search.advanced.result.model.Match#getMatchedSubstringIndices()
     */
    public int[][] getMatchedSubstringIndices() {
        return matchedSubstringIndices;
    }

    /* (non-Javadoc)
     * @see mpi.eudico.search.advanced.result.model.Match#getRightContext()
     */
    public String getRightContext() {
        return rightContext;
    }

    /* (non-Javadoc)
     * @see mpi.eudico.search.advanced.result.model.Match#getTierName()
     */
    public String getTierName() {
        return tierName;
    }
}
