/*
 * File:     ContentResult.java
 * Project:  MPI Linguistic Application
 * Date:     12 December 2007
 *
 * Copyright (C) 2001-2008  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

/* This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
package mpi.search.content.result.model;

import mpi.search.result.model.Match;
import mpi.search.result.model.Result;

import java.util.ArrayList;
import java.util.List;


/**
 * Created on Jul 27, 2004
 *
 * @author Alexander Klassmann
 * @version Jul 27, 2004
 */
public class ContentResult extends Result {
    /** Holds value of property DOCUMENT ME! */
    private final List tierNames = new ArrayList();
    private int occurrenceCount = 0;

    /**
     * DOCUMENT ME!
     *
     * @param match
     *            DOCUMENT ME!
     */
    public void addMatch(Match match) {
        super.addMatch(match);

        if (match instanceof ContentMatch) {
            if (!tierNames.contains(((ContentMatch) match).getTierName())) {
                tierNames.add(((ContentMatch) match).getTierName());
            }

            if (((ContentMatch) match).getMatchedSubstringIndices() != null) {
                occurrenceCount += ((ContentMatch) match).getMatchedSubstringIndices().length;
            }
        }
    }

    /**
     * DOCUMENT ME!
     *
     * @param tierName
     *            DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public List getMatches(String tierName) {
        if (tierName == null) {
            return null;
        }

        List matchesInTier = new ArrayList();

        for (int i = 1; i <= getRealSize(); i++) {
            if (tierName.equals(((ContentMatch) getMatch(i)).getTierName())) {
                matchesInTier.add(getMatch(i));
            }
        }

        return matchesInTier;
    }

    /**
     * DOCUMENT ME!
     */
    public void reset() {
        super.reset();
        tierNames.clear();
        occurrenceCount = 0;
    }

    /**
     * returns a list of all tierNames present in matches. Ordered along first
     * occurence.
     *
     * @return List
     */
    public String[] getTierNames() {
        return (String[]) tierNames.toArray(new String[0]);
    }

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public int getOccurrenceCount() {
        return occurrenceCount;
    }
}
