/*
 * File:     ContentResult2HTML.java
 * Project:  MPI Linguistic Application
 * Date:     12 December 2007
 *
 * Copyright (C) 2001-2008  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

package mpi.search.content.result.viewer;

import mpi.search.SearchLocale;

import mpi.search.content.result.model.ContentMatch;
import mpi.search.content.result.model.ContentResult;

import mpi.util.TimeFormatter;


/**
 * $Id: ContentResult2HTML.java 8065 2007-02-01 16:08:13Z klasal $
 *
 * @author $author$
 * @version $Revision$
 */
public class ContentResult2HTML {
    /**
     * appends match to StringBuffer with included highlight tags
     *
     * @param sb
     * @param match
     */
    public static void appendMatchValue(StringBuffer sb, ContentMatch match) {
        String s = match.getValue();
        int[][] highlights = match.getMatchedSubstringIndices();

        if ((highlights != null) &&
                ContentResult2HTML.arrayIsConsistent(s, highlights)) {
            String substring;

            if (highlights.length > 0) {
                for (int j = 0; j < highlights.length; j++) {
                    substring = s.substring((j == 0) ? 0 : highlights[j - 1][1],
                            highlights[j][0]);

                    sb.append(substring);

                    substring = s.substring(highlights[j][0], highlights[j][1]);
                    sb.append("<b>" + substring + "</b>");
                }

                sb.append(s.substring(highlights[highlights.length - 1][1]));
            } else {
                sb.append(s);
            }
        } else {
            sb.append(s);
        }
    }

    /**
     * appends all matches of a result as HTML to a StringBuffer
     *
     * @param sb Buffer to append data
     * @param result
     */
    public static void appendResultAsTable(StringBuffer sb, ContentResult result) {
        sb.append("<table border=\"1\" rules=\"all\" cellpadding=\"3\">\n");
        sb.append("<thead><tr><th>" +
            SearchLocale.getString("Search.Table.Count") + "</th><th>" +
            SearchLocale.getString("Search.Annotation_SG") + "</th><th>" +
            SearchLocale.getString("Search.Table.BeginTime") + "</th><th>" +
            SearchLocale.getString("Search.Table.EndTime") + "</th><th>" +
            SearchLocale.getString("Search.Table.Duration") +
            "</th></tr></thead>\n<tbody>");

        for (int i = 0; i < result.getRealSize(); i++) {
            ContentMatch match = (ContentMatch) result.getMatch(i + 1);
            sb.append("<tr>");
            sb.append("<td align=\"right\">" + (i + 1) + "</td><td>");
            appendMatchValue(sb, match);
            sb.append("</td><td align=\"right\">" +
                TimeFormatter.toSSMSString(match.getBeginTimeBoundary()) +
                "</td><td align=\"right\">" +
                TimeFormatter.toSSMSString(match.getEndTimeBoundary()) +
                "</td><td align=\"right\">" +
                TimeFormatter.toSSMSString(match.getEndTimeBoundary() -
                    match.getBeginTimeBoundary()) + "</td>");
            sb.append("</tr>\n");
        }

        sb.append("</tbody>\n</table>\n");
    }

    /**
     * checks if highlights are in ascending order and within string size
     *
     * @param s
     * @param highlights
     *
     * @return
     */
    private static boolean arrayIsConsistent(String s, int[][] highlights) {
        for (int j = 0; j < highlights.length; j++) {
            if ((highlights[j][0] < 0) ||
                    (highlights[j][0] > highlights[j][1]) ||
                    (highlights[j][1] > s.length())) {
                return false;
            }
        }

        return true;
    }
}
